/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* sql_common.h -- Useful MYSQL functions */

#ifndef _SQL_COMMON_H
#define _SQL_COMMON_H

#include <schedwi.h>

#if STDC_HEADERS
#include <stdarg.h>
#endif

#include <mysql/mysql.h>
#include <mysql/mysqld_error.h>
#include <lwc_linkedlist.h>


/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
	SQL_END,
	SQL_INT,
	SQL_STRING,
	SQL_STRING_NON_ESCAPE,
	SQL_BIN,
	SQL_BOOL
} sql_type;


extern void destroy_db_connection OF(());
extern MYSQL * begin_mysql OF((char **err_msg));
extern void end_mysql OF(());
extern int compose_error_message OF((const char *msg, char **msg_out));
extern char *sql_escape OF((MYSQL *sql, const char *s));
extern unsigned int sql_non_select OF((	char **buf, unsigned int *buf_len,
					char **err_msg, unsigned long int *id,
					unsigned long long int *affected_rows,
					const char *fmt, ...));
extern void sql_free_row OF((char **row));
extern unsigned int sql_select OF((	char **buf, unsigned int *buf_len,
					char **err_msg,
					unsigned int *num_columns,
					lwc_LL **rows,
					lwc_LL **fields_len,
					const char *fmt, ...));
extern void sql_thread_init OF(());
extern void sql_thread_end OF(());

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* sql_common.h */

/*-----------------============== End Of File ==============-----------------*/
