/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* pref_cb.h -- GUI functions for the preferences window */

#ifndef _PREF_CB_H
#define _PREF_CB_H

#include <schedwi.h>
#include <gtk/gtk.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern GtkWidget *new_dialog_pref OF((	void (*destroy_cb)(gpointer),
					gpointer user_data));
extern void pref_close_clicked OF((GtkButton *button));
extern gboolean pref_delete_event OF((GtkWidget *widget));
extern void pref_database_host_changed_cb OF((GtkEntry *entry));
extern void pref_database_user_changed_cb OF((GtkEntry *entry));
extern void pref_database_database_changed_cb OF((GtkEntry *entry));
extern void pref_database_port_changed_cb OF((GtkSpinButton *spin));
extern void pref_database_socket_changed_cb OF((GtkEditable *editable));
extern void pref_grid_line_style_changed_cb OF((GtkComboBox *combo_box));
extern void pref_grid_color_set_cb OF((GtkColorButton *color_button));
extern void pref_grid_ratio_clicked OF((GtkButton *button));
extern void pref_grid_width_changed_cb OF((GtkSpinButton *spin));
extern void pref_grid_height_changed_cb OF((GtkSpinButton *spin));
extern void pref_calendar_months_by_row_changed_cb OF((GtkSpinButton *spin));
extern void pref_calendar_first_day_of_week_changed_cb OF((
						GtkComboBox *combo_box));
extern void pref_calendar_font_set_cb OF((GtkFontButton *font_button));
extern void pref_calendar_use_system_font_toggled_cb OF((
					GtkToggleButton *toggle_button));
extern void pref_database_restore_activated_cb OF((GtkButton *button));
extern void pref_database_test_clicked_cb OF((GtkButton *button));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* pref_cb.h */

/*-----------------============== End Of File ==============-----------------*/
