/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include <gnutls/gnutls.h>

#include "interface.h"

#include <schedwi_gconf.h>
#include <schedwi_main.h>
#include <main_cb.h>

GtkWidget *application_main;


/*
 * Main function
 */
int
main (int argc, char *argv[])
{

#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	gnome_program_init (	PACKAGE, VERSION, LIBGNOMEUI_MODULE,
				argc, argv,
				GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
				NULL);


	/* Initializations */
	gnutls_global_init ();
	schedwi_gconf_init ();

	/* Show the application window */
	application_main = new_dialog_main ();

	/* Login */
	schedwi_main_login ();

	/* Main loop */
	gtk_main ();

	gnutls_global_deinit ();

	return 0;
}

/*-----------------============== End Of File ==============-----------------*/
