/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/*
 * lib_functions.h -- Library functions that may be not available on every
 *                    operating system. Their behavior may be slightly
 *                    different than the library one but their are alright
 *                    for schedwi
 */

#ifndef _LIB_FUNCTIONS_H
#define _LIB_FUNCTIONS_H

#ifndef OF /* function prototypes */
#  if defined __STDC__ || defined PROTOTYPES 
#    define OF(args)  args
#  else
#    define OF(args)  ()
#  endif
#endif

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern void *schedwi_memset OF((void *s, int c, unsigned int n));
extern void *schedwi_memcpy OF((void *dest, const void *src, unsigned int n));
extern int schedwi_toupper OF((int c));
extern int schedwi_strcasecmp OF((const char *s1, const char *s2));
extern int schedwi_strncasecmp OF((const char *s1, const char *s2,
					unsigned int n));
extern unsigned int schedwi_strlen OF((const char *s));
extern int schedwi_strncmp OF((	const char *s1, const char *s2,
				unsigned int n));
extern char *schedwi_strnstr OF((char *haystack,
				const char *needle, unsigned int n));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* lib_functions.h */

/*-----------------============== End Of File ==============-----------------*/
