/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* grid.h -- Structure to draw a grid on a GnomeCanvas */

#ifndef _GRID_H
#define _GRID_H

#include <schedwi.h>
#include <glib.h>
#include <libgnomecanvas/libgnomecanvas.h>
#include <gdk/gdk.h>


/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

enum line_style {
	LINE_STYLE_SOLID,
	LINE_STYLE_DASH,
	LINE_STYLE_CROSS
};
typedef enum line_style line_style_t;

struct grid {
	gint spacing_width, spacing_height;
	gint canvas_width, canvas_height;
	GdkColor color;
	line_style_t style;
	gboolean show;
	gboolean snap;
	guint gconf_notify;
	GnomeCanvasGroup *parent_group, *canvas_grid;
};
typedef struct grid grid_t;


extern grid_t *new_grid OF(());
extern void destroy_grid OF((grid_t *ptr));
extern void snap_to_grid OF((grid_t *ptr, gboolean snap));
extern void hide_grid OF((grid_t *ptr));
extern void set_grid_parent_group OF((	grid_t *ptr,
					GnomeCanvasGroup *parent_group,
					gint canvas_width, gint canvas_height));
extern void show_grid OF((grid_t *ptr));
extern void grid_get_coordinate OF((	grid_t *ptr,
					gint icon_width, gint icon_height,
					gdouble mouse_x, gdouble mouse_y,
					gdouble *out_x, gdouble *out_y));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* grid.h */

/*-----------------============== End Of File ==============-----------------*/
