/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* druid_cb.c -- GUI functions for the druid window */

#include <schedwi.h>

#include "support.h"
#include "interface.h"

#include <message_windows.h>
#include <database_test_cb.h>
#include <schedwi_gconf.h>
#include <druid_cb.h>


/*
 * Callback for the `Finish' button
 */
void
druid_finish_clicked (GnomeDruidPage *druidpage, GtkWidget *druid)
{
	GtkWidget *w;
	gchar *s;
	gpointer *user_data;
	void (*finish_cb)(gpointer);

	/* Store the database parameters in GConf */
	if (gconf_client_key_is_writable (schedwi_gconf,
					GCONF_PATH "/database/host",
					NULL) == TRUE)
	{
		w = lookup_widget (druid, "entry_druid_host");
		gconf_client_set_string (schedwi_gconf,
				GCONF_PATH "/database/host",
				gtk_entry_get_text (GTK_ENTRY (w)),
				NULL);
	}

	if (gconf_client_key_is_writable (schedwi_gconf,
				GCONF_PATH "/database/username",
				NULL) == TRUE)
	{
		w = lookup_widget (druid, "entry_druid_user");
		gconf_client_set_string (schedwi_gconf,
				GCONF_PATH "/database/username",
				gtk_entry_get_text (GTK_ENTRY (w)),
				NULL);
	}

	if (gconf_client_key_is_writable (schedwi_gconf,
				GCONF_PATH "/database/database",
				NULL) == TRUE)
	{
		w = lookup_widget (druid, "entry_druid_database");
		gconf_client_set_string (schedwi_gconf,
				GCONF_PATH "/database/database",
				gtk_entry_get_text (GTK_ENTRY (w)),
				NULL);
	}

	if (gconf_client_key_is_writable (schedwi_gconf,
				GCONF_PATH "/database/port",
				NULL) == TRUE)
	{
		w = lookup_widget (druid, "spinbutton_druid_port");
		gconf_client_set_int (	schedwi_gconf,
					GCONF_PATH "/database/port",
					gtk_spin_button_get_value_as_int (
							GTK_SPIN_BUTTON (w)),
					NULL);
		
	}

	if (gconf_client_key_is_writable (schedwi_gconf,
				GCONF_PATH "/database/socket",
				NULL) == TRUE)
	{
		w = lookup_widget (druid, "fileentry_druid_socket");
		s = gnome_file_entry_get_full_path (	GNOME_FILE_ENTRY (w),
							FALSE);
		gconf_client_set_string (schedwi_gconf,
					GCONF_PATH "/database/socket",
					s,
					NULL);
		g_free (s);
	}

	/* Destroy the druid */
	w = lookup_widget (druid, "window_druid");
	user_data = g_object_get_data (G_OBJECT (w), "finish_cb_data");
	finish_cb = g_object_get_data (G_OBJECT (w), "finish_cb");
	gtk_widget_destroy (w);

	/* Call the user provided function */
	if (finish_cb != NULL) {
		finish_cb (user_data);
	}
}


/*
 * Callback for the test connection button
 */
void
druid_test_database_clicked (GtkButton *button)
{
	int ret;
	GtkWidget *last_page, *druid;

	/* Test the connection */
	ret = database_test_go (GTK_WIDGET (button));

	/* Update the final page accordingly */	
	druid = lookup_widget (GTK_WIDGET (button), "druid1");
	last_page = lookup_widget (GTK_WIDGET (button), "druidpagefinish1");
	if (ret == 0) {
		gnome_druid_page_edge_set_text (
			GNOME_DRUID_PAGE_EDGE (last_page),
_("The database connection has been successfully configured and tested.  To save your new connection settings click on \"Apply\".\nYou can later access these settings through the Preferences window in the Edit menu.  Alternatively, you can re-run this Assistant from the Database Assistant option in the Edit menu."));
		gnome_druid_set_page (	GNOME_DRUID (druid),
					GNOME_DRUID_PAGE (last_page));
	}
	else {
		gnome_druid_page_edge_set_text (
			GNOME_DRUID_PAGE_EDGE (last_page),
_("The database connection test has failed.  You should try to fix this connection issue before proceding further. However you can save your new connection settings by clicking on \"Apply\".\nYou can later access these settings through the Preferences window in the Edit menu.  Alternatively, you can re-run this Assistant from the Database Assistant option in the Edit menu."));
		warning_window (_("Database Connection failed"), NULL);
	}
}


/*
 * Build the new window
 */
static gint
dialog_druid_build (GtkWidget *main_window)
{
	GtkWidget *w;
	GConfValue *v;

	/* Fill the fields */
	v = gconf_client_get (	schedwi_gconf,
				GCONF_PATH "/database/host",
				NULL);
	if (v != NULL) {
		w = lookup_widget (main_window, "entry_druid_host");
		gtk_entry_set_text (	GTK_ENTRY (w),
					gconf_value_get_string (v));
		gconf_value_free (v);
	}

	v = gconf_client_get (	schedwi_gconf,
				GCONF_PATH "/database/database",
				NULL);
	if (v != NULL) {
		w = lookup_widget (main_window, "entry_druid_database");
		gtk_entry_set_text (	GTK_ENTRY (w),
					gconf_value_get_string (v));
		gconf_value_free (v);
	}

	v = gconf_client_get (	schedwi_gconf,
				GCONF_PATH "/database/username",
				NULL);
	if (v != NULL) {
		w = lookup_widget (main_window, "entry_druid_user");
		gtk_entry_set_text (	GTK_ENTRY (w),
					gconf_value_get_string (v));
		gconf_value_free (v);
	}

	v = gconf_client_get (	schedwi_gconf,
				GCONF_PATH "/database/port",
				NULL);
	if (v != NULL) {
		w = lookup_widget (main_window, "spinbutton_druid_port");
		gtk_spin_button_set_value (	GTK_SPIN_BUTTON (w),
						gconf_value_get_int (v));
		gconf_value_free (v);
	}

	v = gconf_client_get (	schedwi_gconf,
				GCONF_PATH "/database/socket",
				NULL);
	if (v != NULL) {
		w = lookup_widget (main_window, "fileentry_druid_socket");
		gnome_file_entry_set_filename (	GNOME_FILE_ENTRY (w),
						gconf_value_get_string (v));
		gconf_value_free (v);
	}

	return 0;
}


/*
 * Create the druid window
 *
 * Return:
 *   The new GtkWidget (`show'ed by this function) or
 *   NULL in case of error (an error message has been displayed for the user)
 */
GtkWidget *
new_dialog_druid (void (*finish_cb)(gpointer), gpointer user_data)
{
	GtkWidget *widget;

	widget = create_window_druid ();
	if (dialog_druid_build (widget) != 0) {
		gtk_widget_destroy (widget);
		return NULL;
	}
	else {
		g_object_set_data (	G_OBJECT (widget),
					"finish_cb_data", user_data);
		g_object_set_data (	G_OBJECT (widget),
					"finish_cb", finish_cb);
		gtk_widget_show (widget);
		return widget;
	}
}

/*------------------------======= End Of File =======------------------------*/
