/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* conf.h -- Configuration file management functions */

#ifndef _CONF_H
#define _CONF_H

#include <schedwi.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
	INT,
	STRING,
	BOOL,
	SYSLOG_FACILITY
} conf_param_type;


struct conf_param {
	const char *name;		/* Parameter name */
	conf_param_type type;		/* Parameter type */
	union {				/* Parameter value */
		long int value_int;
		char *value_string;
		char value_bool;
	} value;
	const char *(*check)(const char *); /* Function to check the value */
	char is_set;        /* Does this parameter is set in the conf file */
	const char *default_value;          /* Default value */
};
typedef struct conf_param conf_param_t;

extern const char *check_syslog_facility OF((const char *s));
extern const char *check_bool OF((const char *s));
extern const char *check_int OF((const char *s));
extern const char *check_dirname OF((const char *s));

extern void conf_destroy OF(());
extern int conf_init OF((const char *file_name, conf_param_t *params_array));
extern int conf_get_param_string OF((const char *name, const char **value));
extern int conf_get_param_int OF((const char *name, long int *value));
extern int conf_get_param_bool OF((const char *name, char *value));
extern int conf_get_param_syslog_facility OF((	const char *name,
						long int *value));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* conf.h */

/*-----------------============== End Of File ==============-----------------*/
