/* Schedwi
   Copyright (C) 2007 Herve Quatremain

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* commands.c -- commands management functions */

#include <schedwi.h>

#include <sql_commands.h>
#include <commands.h>


/*
 * Convert a command to an int
 */
static int
command_to_int (command_t cmd)
{
	switch (cmd) {
		case COMMAND_CHANGE_STATUS:	return 1;
		case COMMAND_STOP:		return 2;
		default:			return 0;
	}
}


/*
 * Add a new command to the database commands table
 *
 * Return:
 *   0 --> No error
 *  -1 --> Error.  If not NULL, err_msg contains the error message and
 *         must be freed by the caller by free()
 */
int
command_add (	int workload, const char *job_id,
		const char *username, command_t cmd, int parameter,
		char **err_msg)
{
	if (sql_command_add (	workload, job_id,
				username,
				command_to_int (cmd),
				parameter,
				err_msg) != 0)
	{
		return -1;
	}
	return 0;
}

/*-----------------============== End Of File ==============-----------------*/
