/* Schedwi
   Copyright (C) 2007 Herve Quatremain
     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
     
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
     
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/* canvas_utils.h -- Utility functions for the job/jobset canvas */

#ifndef _CANVAS_UTILS_H
#define _CANVAS_UTILS_H

#include <schedwi.h>
#include <libgnomecanvas/libgnomecanvas.h>

/* Allow the use in C++ code.  */
#ifdef __cplusplus
extern "C" {
#endif

extern gdouble canvas_utils_get_default_text_size OF((GnomeCanvas *canvas));
extern guint canvas_utils_zoom_in OF((GnomeCanvas *canvas));
extern guint canvas_utils_zoom_out OF((GnomeCanvas *canvas));
extern guint canvas_utils_zoom_normal OF((GnomeCanvas *canvas));
extern gint canvas_utils_zoom_save OF((GnomeCanvas *canvas));
extern guint canvas_utils_zoom_restore OF((	GnomeCanvas *canvas,
						gint new_level));
extern void canvas_utils_get_position OF((	GnomeCanvas *canvas,
						gdouble *v, gdouble *h));
extern void canvas_utils_set_position OF((	GnomeCanvas *canvas,
						gdouble v, gdouble h));
extern void canvas_utils_copy OF((	GnomeCanvas *dst, GnomeCanvas *src,
					gdouble ratio));
extern void canvas_utils_clean OF((GnomeCanvas *canvas));
extern void canvas_utils_set_size OF((	GnomeCanvas *canvas,
					gint width, gint height));
extern void canvas_utils_get_size OF((	GnomeCanvas *canvas,
					gint *width, gint *height));

#ifdef __cplusplus
}
#endif  /* C++ */

#endif /* canvas_utils.h */

/*-----------------============== End Of File ==============-----------------*/
