#!/usr/bin/perl

#   Rebot 0.9 (beta): Bot para aventuras de texto por red
#   http://aventuras.presi.org/rebot
#   (C) 2005 Enrique D. Bosch 'presi'
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#   http://www.gnu.org/licenses/gpl.html

use FileHandle;
use File::Which;
use File::Spec;
use rebot_conf;

BEGIN
{
$d_tmp=$rebot_conf::dir_temp;                    # Inicializando parmetros
$d_interprete=$rebot_conf::dir_interpr;          # de configuracin
$d_aventura=$rebot_conf::dir_adventures;
$d_aplic=$rebot_conf::dir_applications;
$log=$rebot_conf::mod_log;
eval "require $log";                # Incluyendo mdulo de log
$con=$rebot_conf::mod_protocol;
eval "require $con";                # Incluyendo mdulo de protocolo
$mod_lang="rebot_lang_$rebot_conf::language";
eval "require $mod_lang";           # Incluyendo mdulo de lenguaje
}

undef $/;
$modo_comando=1;
$linea1_texto_inicial="Rebot 0.9 (beta): $MSG_bot_descr http://aventuras.presi.org/rebot";
$texto_inicial="$linea1_texto_inicial\n$MSG_see_help";

sub cargar
{
  $aventura=$_[0];
  $interprete=$_[1];
  $donde=$_[2];
  my $cand_interprete;

  if ($interprete eq '-aplic-')  # Comprobando si la aplicacin existe
  {
    if (!esta_en_directorio($d_aplic,$aventura,$MSG_ap_no_enc)) { return 0; }
  }
  else  # Comprobando si la aventura existen
  {
    if (!esta_en_directorio($d_aventura,$aventura,$MSG_av_no_enc)) { return 0; }
    foreach my $aux (@rebot_conf::extensions_interpr)
    {                                          # Buscando intrprete para la aventura
      my ($ext,$int,$opc)=@$aux;
      if ($aventura=~/\.$ext/i) { $cand_interprete=$int; $opciones=$opc; }
    }
    if ($interprete eq '') { $interprete=$cand_interprete; } # si no hay intrprete se asigna

    if ( ($cand_interprete ne $interprete) && $rebot_conf::strict_int )
    {
      $log->eslog("'$interprete': $MSG_int_no_ad '$aventura'",5);
      $con->enviar_mensaje($MSG_int_no_ad);
      modo('',$donde);
      return 0;
    }
        # Comprobando si el intrprete existe
    if (!esta_en_directorio($d_interprete,$interprete,$MSG_int_no_enc)) { return 0; }
  }
  # Lanzando aventura o aplicacin

  my $linea;
  my $mens; my $mensl; my $mensi; my $mensf;

  my $bin_perl=which('perl');                           # Preparando lnea de
  $tmp_file=File::Spec->catfile($d_tmp,"tmp$$");     # ejecucin y mensajes
  $err_file=File::Spec->catfile($d_tmp,"err$$");

  if ($interprete eq '-aplic-')                   # para aplicaciones
  {
    my $app_path=File::Spec->catfile($d_aplic,$aventura);
    $linea="$bin_perl la.pl $$ $tmp_file $err_file $app_path";
    $mens="$MSG_ap '$aventura' $MSG_ap_carg1";
    $mensl=$MSG_ap_carg2;
    $mensi=$MSG_lap;
    $mensf=$MSG_ap_end;
  }
  else                                            # para aventuras
  {
    my $interprete_path=File::Spec->catfile($d_interprete,$interprete);
    my $aventura_path=File::Spec->catfile($d_aventura,$aventura);
    $linea="$bin_perl la.pl $$ $tmp_file $err_file $interprete_path $opciones $aventura_path";
    $mens="$MSG_av '$aventura' $MSG_av_carg1 '$interprete'";
    $mensl=$MSG_av_carg2;
    $mensi=$MSG_lav;
    $mensf=$MSG_av_end;
  }
  $log->eslog($linea,3);  
  open(ESINT," | $linea") or die "$MSG_err_lanz $mensi";
  ESINT->autoflush(1);
  sleep $rebot_conf::la_delay;
  open(ERR,$err_file) or die $MSG_err_tmp;
  my $er=<ERR>;
  close(ERR);
  if ($er ne '')
  {
    $log->eslog($er,3);
    $log->eslog("$mensf $MSG_err",5);
    $con->enviar_mensaje("$MSG_err_lanz $mensi");
    modo('',$donde);
    close(ESINT);
    borr_tmp();
  }
  else
  {
    open(LEINT,$tmp_file) or die $MSG_err_tmp;
    LEINT->autoflush(1);
    my $le=<LEINT>;
    my @lel=split("\n",$le);
    if ($lel[@lel-1] eq $xml_end)            # se comprueba si el intrprete se aborta
    {
      $log->eslog($le,3);
      $log->eslog("$mensf $MSG_err",5);
      $con->enviar_mensaje("$MSG_err_lanz $mensi");
      modo('comando',$donde);
      close(ESINT);
      close(LEINT);
      borr_tmp();
    }
    else
    {
      $log->eslog($mensl,4);
      $con->enviar_mensaje($mens,$donde);
      modo('juego',$donde);
      $con->enviar_mensaje($le,$donde);      # se vuelca la respuesta
    }
  }
}

sub leer_dir   # Lee un directorio y lo coloca en un array
{
  my $dir=$_[0];

  opendir(DIR,$dir) or die $MSG_err_dir;
  my @lista=readdir(DIR);
  closedir(DIR);
  if ($lista[0] eq '.')
  {
    shift(@lista);
    if ($lista[0] eq '..') { shift(@lista); }
  }
  return @lista;
}

sub listar_dir  # Lee y lista un directorio
{
  my $dir=$_[0];
  my $donde=$_[1];

  my @lista=leer_dir($dir);
  $con->enviar_mensaje(join("\n",@lista),$donde);
}

sub esta_en_directorio
{
  my $dir=$_[0];
  my $fich=$_[1];
  my $mens_no_enc=$_[2];

  my @lista=leer_dir($dir);
  my $enc=0;
  foreach my $item (@lista)   # Comprobando si el fichero est en el directorio
  {
    if ($item eq $fich) { $enc=1; }
  }
  if ($enc==0)
  {
    $log->eslog("'$fich': $mens_no_enc",5);
    $con->enviar_mensaje($mens_no_enc);
    modo('',$donde);
    return 0;
  }
  return 1;
}

sub ayuda
{
  my $donde=$_[0];
  my $texto_ayuda=$MSG_help."\n".$con->texto_ayuda();
  $con->enviar_mensaje($texto_ayuda,$donde);
}

sub tratar_texto    # Maneja el texto de entrada
{
   my $texto=$_[0];
   my $donde=$_[1];

   if ($modo_comando)  # Parser de comandos
   {
      my @elem=split(' ',$texto);
      lc($elem[0]);
      if ( ($elem[0] eq $COM_cargar) || ($elem[0] eq $COM_jugar) )
      {
         cargar($elem[1],$elem[2],$donde);
      }
      elsif ( ($elem[0] eq $COM_aventuras) || ($elem[0] eq $COM_juegos) )
      {
         listar_dir($d_aventura,$donde);
         modo('',$donde);
      }
      elsif ( $elem[0] eq $COM_interpretes )
      {
         listar_dir($d_interprete,$donde);
         modo('',$donde);
      }
      elsif ( $elem[0] eq $COM_ejecutar)
      {
         cargar($elem[1],'-aplic-',$donde);
      }
      elsif ( $elem [0] eq $COM_aplicaciones)
      {
         listar_dir($d_aplic,$donde);
         modo('',$donde);
      }
      elsif ( ($elem[0] eq $COM_ayuda) || ( $elem[0] eq $COM_interrogante) )
      {
         ayuda($donde);
         modo('',$donde);
      }
      elsif ( !($con->comando($donde,@elem)) )
          { $con->enviar_mensaje($MSG_no_com,$donde); modo('',$donde); }
   }
   else
   {
      print ESINT $texto,"\n";  # se le pasa al intrprete
      sleep $rebot_conf::ap_delay;
      $le=<LEINT>;         # primera respuesta del intrprete
      if ($le eq '')       # si es vaca obtener una segunda
         { $le=<LEINT>; }
      my @lel=split("\n",$le);
      if ($lel[@lel-1] eq $xml_end) # se comprueba si ha acabado el interprete
      {
        $log->eslog($MSG_av_end,4);
        modo('comando',$donde);
        close(ESINT);
        close(LEINT);
        borr_tmp();
      }
      else { $con->enviar_mensaje($le,$donde); }      # se vuelca la respuesta
    }

}


sub modo   # Cambio/consulta de modo (comando o juego)
{
  my $cad_modo=$_[0];
  my $donde=$_[1];

  if ($cad_modo eq '')
  {
    print_modo($modo_comando,$donde,0);
  }
  elsif ($cad_modo eq 'comando')
  {
    $modo_comando=1;
    print_modo(1,$donde,1);
  }
  elsif ($cad_modo eq 'juego')
  {
    $modo_comando=0;
    print_modo(0,$donde,1);
  }
  else { $log->eslog($MSG_mod_err,1); }
}

sub print_modo
{
  my $modo=$_[0];
  my $donde=$_[1];
  my $loggear=$_[2];

  if ($modo)
  {
    if ($loggear) { $log->eslog($MSG_mod_com,2); }
    $con->enviar_mensaje("--$MSG_mod_com--",$donde);
  }
  else
  {
    if ($loggear) { $log->eslog($MSG_mod_ap,2); }
    $con->enviar_mensaje("--$MSG_mod_ap--",$donde);
  }
}

sub borr_tmp
{
  unlink($tmp_file);
  unlink($err_file);
}

my @txt_ini=split("\n",$texto_inicial);
$log->eslog($txt_ini[0],5);
$log->eslog("$MSG_mod '$con'",5);
$log->eslog($con.': '.$con->texto_inicial(),5);
$con->configurar();
$con->conectar();

BEGIN     # Copiando mensajes en variables locales para simplificar sintaxis
{
  $MSG_bot_descr=${qq(${mod_lang}::bot_descr)};
  $MSG_see_help=${qq(${mod_lang}::see_help)};
  $MSG_ap_no_enc=${qq(${mod_lang}::ap_no_enc)};
  $MSG_av_no_enc=${qq(${mod_lang}::av_no_enc)};
  $MSG_int_no_enc=${qq(${mod_lang}::int_no_enc)};
  $MSG_int_no_ad=${qq(${mod_lang}::int_no_ad)};
  $MSG_ap=${qq(${mod_lang}::ap)};
  $MSG_ap_carg1=${qq(${mod_lang}::ap_carg1)};
  $MSG_ap_carg2=${qq(${mod_lang}::ap_carg2)};
  $MSG_lap=${qq(${mod_lang}::lap)};
  $MSG_ap_end=${qq(${mod_lang}::ap_end)};
  $MSG_av=${qq(${mod_lang}::av)};
  $MSG_av_carg1=${qq(${mod_lang}::av_carg1)};
  $MSG_av_carg2=${qq(${mod_lang}::av_carg2)};
  $MSG_lav=${qq(${mod_lang}::lav)};
  $MSG_av_end=${qq(${mod_lang}::av_end)};
  $MSG_err=${qq(${mod_lang}::err)};
  $MSG_err_lanz=${qq(${mod_lang}::err_lanz)};
  $MSG_err_tmp=${qq(${mod_lang}::err_tmp)};
  $MSG_err_dir=${qq(${mod_lang}::err_dir)};
  $MSG_no_com=${qq(${mod_lang}::no_com)};
  $MSG_mod_err=${qq(${mod_lang}::mod_err)};
  $MSG_mod_com=${qq(${mod_lang}::mod_com)};
  $MSG_mod_ap=${qq(${mod_lang}::mod_ap)};
  $MSG_mod=${qq(${mod_lang}::mod)};
  $MSG_end=${qq(${mod_lang}::end)};
  $MSG_help=${qq(${mod_lang}::help)};
  $COM_cargar=${qq(${mod_lang}::cargar)};
  $COM_jugar=${qq(${mod_lang}::jugar)};
  $COM_aventuras=${qq(${mod_lang}::aventuras)};
  $COM_juegos=${qq(${mod_lang}::juegos)};
  $COM_interpretes=${qq(${mod_lang}::interpretes)};
  $COM_ejecutar=${qq(${mod_lang}::ejecutar)};
  $COM_aplicaciones=${qq(${mod_lang}::aplicaciones)};
  $COM_ayuda=${qq(${mod_lang}::ayuda)};
  $COM_interrogante=${qq(${mod_lang}::interrogante)};
  $xml_end='<?xml version="1.0"?><rebot id="'.$$.'"><application action="end"/></rebot>';
}

END
{
  $log->eslog($MSG_end,4);
}
