##  You should have received a copy of the GNU General Public License
##
##  This file is part of pyFormex 2.1  (Sat Oct 24 14:52:22 CEST 2020)
##  pyFormex is a tool for generating, manipulating and transforming 3D
##  geometrical models by sequences of mathematical operations.
##  Home page: http://pyformex.org
##  Project page:  http://savannah.nongnu.org/projects/pyformex/
##  Copyright 2004-2020 (C) Benedict Verhegghe (benedict.verhegghe@ugent.be)
##  Distributed under the GNU General Public License version 3 or later.
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program.  If not, see http://www.gnu.org/licenses/.
##
"""ColorRGBA

This example demonstrates the use of RGBA color model in drawing
operations.

"""


_status = 'checked'
_level = 'normal'
_topics = ['drawing']
_techniques = ['color', 'rgba', 'transparency']

from pyformex.gui.draw import *

def run():
    reset()
    clear()
    transparent(False)
    flat()
    nx, ny = 1, 1
    F = Formex('4:0123').replicm((nx, ny)).centered()
    G = F.scale(0.8)
    F1 = F.trl(0, 1.2)
    G1 = G.trl(0, 1.2)
    F.attrib(color = [[(1., 0, 0), (0, 1, 0), (0, 0, 1), (1, 0, 1)]])
    F1.attrib(color = [[(1, 0, 0, 0.0), (0, 1, 0, 1), (0, 0, 1, 1), (1, 0, 1, 0)]])
    FA = draw(F)
    FB = draw(F1)
    draw(G)
    draw(G1)
    print("Colors of the left square:")
    print(FA.color)
    print("Colors of the right square:")
    print(FB.color)
    if pf.options.shader == 'alpha':
         showInfo("""..

These two colored squares were drawn with RGBA color mode using the alpha
shader. The RGB components are the same for both squares. The squares hide
a smaller black square.

For the left square only RGB components were given, without A value:
the default 0.5 is then used for all points.
For the right square the value of A was set to 0.0 at the left corners
and to 1.0 at the right corners, making the transparency
range from full to minimal over the square.

To see the effect, transparency needs to be switched on. I will do that
when you push the OK button.
""")
         transparent(True)
    else:
         showInfo("""..

The effect of the RGBA color mode can currently only be visualized
when using the alpha shader. Start pyFormex with the command::

  pyformex --shader=alpha

""")



if __name__ == '__draw__':
    run()

# End
