/* Copyright (C) 2012 Rudra Banerjee*/

/*
    This file is part of ptbl.

    ptbl is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    ptbl is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ptbl.  If not, see <http://www.gnu.org/licenses/>.

*/

#include <gtk/gtk.h>

int callback_Li( int   argc,
          char *argv[] )
{
  static GtkWidget *window = NULL;
  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *frame;
  GtkWidget *label;


  /* Initialise GTK */
  gtk_init(&argc, &argv);

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Li");
  vbox = gtk_vbox_new (FALSE, 0);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), hbox);
  gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (window), 5);


  frame = gtk_frame_new ("Properties");
  label = gtk_label_new ("Name\nSymbol\nAtomic Number\n"                         "Atomic Weight\nElectron configuration\n"                          "Phase\nMelting point\nBoiling point\n"                          "Electronegativity\nElectronAffinity \n"                          "Valence \nAtomic radius \n"                         "Crystal structure\nLattice Constant\n"                         "Space Group");
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_container_add (GTK_CONTAINER (frame), label);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);

  frame = gtk_frame_new ("Values");
  label = gtk_label_new (NULL);
  char *str="Lithium  \nLi\n"                          "3  \n6.941\n[He]2s<sup>1</sup>\n"                          "Solid  \n180.54 °C \n1342 °C\n"                          "0.98 \n59.6 kJ/mol\n"                          "3    \n167 pm \n"                          "Body Centered Cubic  \n351 pm\n"                          "Im_3m [229]";
  gtk_label_set_markup(GTK_LABEL(label), str);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_container_add (GTK_CONTAINER (frame), label);
  gtk_box_pack_start (GTK_BOX (hbox), frame, FALSE, FALSE, 0);

  gtk_window_set_resizable(GTK_WINDOW (window), FALSE);
  gtk_widget_show_all (window);

//  gtk_main ();
  
//  return(0);
}

