/* Read configuration file and set global vars
 *  
 * Copyright (C) 2005 Jia Wang (skyroam@gmail.com)
 *
 *
 *
 * This file is part of phc.
 * Phc is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 2 of the License, or (at your 
 * option) any later version.
 *
 * Phc is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with Phc; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* all functions declared in pyhc.h */
#include <phc.h>
/* functions defined in this file */
int readint (char *line, char *flagstring, int *i, int *num);
int readstr (char *line, char *flagstring, char **s, int *num);
#include <stdio.h>
#include <stdlib.h>
/* read .conf and configure global vars */
void
READCONF ()
{
  FILE *conf;
  char *line;
  /* malloc at least linelen for a line */
  int linelen;
  int stringlen;
  ssize_t read;
  char *offset;
  char *p, *q;
  /* must be customized */
  int set_mytype = 0, set_method = 0;
  /* useful only if mytype != DIRECT */
  int set_myport = 0, set_myhost = 0;
  /* userful only if mytype = xx_AUTH */
  int set_myuserpass = 0;
  /* customizable, it is also ok to use the value in example */
  int set_threads = 0, set_checksite = 0, set_key = 0, set_user_agent =
    0, set_myconreplysize = 0, set_testconreplysize = 0, set_testtagreplysize;

  conf = fopen (PHC_CONF, "r");
  if (conf == NULL)
    {
      perror ("fopen phc.conf");
      exit (EXIT_FAILURE);
    }

  while (1)
    {
      line = NULL;
      linelen = 80;
      read = getaline ((unsigned char **) &line, &linelen, conf);
      if (read == -1)
	break;
      if (read > 0)
	{			/*read=0?  */
	  if (line[0] == '#')
	    continue;
	  if (line[read - 1] == '\n')
	    line[read - 1] = 0;
	  !readint (line, "threads=", &threads, &set_threads)
	    || !readstr (line, "user_agent=", &user_agent, &set_user_agent)
	    || !readint (line, "mytype=", &(my.mytype), &set_mytype)
	    || !readint (line, "myport=", &(my.myport), &set_myport)
	    || !readstr (line, "myhost=", &(my.myhost), &set_myhost)
	    || !readstr (line, "myuserpass=", &(my.myuserpass),
			 &set_myuserpass)
	    || !readstr (line, "checksite=", &(target.target), &set_checksite)
	    || !readstr (line, "key=", &(target.key), &set_key)
	    || !readint (line, "method=", &(test.method), &set_method)
	    || !readint (line, "myconreplysize=", &(my.myconreplysize),
			 &set_myconreplysize)
	    || !readint (line, "testconreplysize=", &(test.testconreplysize),
			 &set_testconreplysize)
	    || !readint (line, "testtagreplysize=", &(test.testtagreplysize),
			 &set_testtagreplysize);

	}
      if (line)
	free (line);
    }

  if (fclose (conf) != 0)
    {
      perror ("fclose");
      exit (EXIT_FAILURE);
    }
  if (set_mytype * set_method
      * set_checksite * set_threads * set_key * set_user_agent *
      set_myconreplysize * set_testconreplysize * set_testtagreplysize == 0)
    {
      fprintf (stderr, "too few config:");
      printf ("set flag are checked:\n"
	      "\tmytype:%d\n"
	      "\tmethod:%d\n"
	      "\tchecksite:%d\n"
	      "\tthreads:%d\n"
	      "\tkey:%d\n"
	      "\tuser_agent:%d\n"
	      "\tmyconreplysize:%d\n"
	      "\ttestconreplysize:%d\n"
	      "\ttesttagreplysize:%d\n",
	      set_mytype, set_method,
	      set_checksite, set_threads, set_key, set_user_agent,
	      set_myconreplysize, set_testconreplysize, set_testtagreplysize);
      exit (EXIT_FAILURE);
    }

  if (my.mytype != DIRECT)
    {
      if (set_myhost * set_myport == 0)
	{
	  fprintf (stderr,
		   "Too few config:myhost or myport isn't set %s\n",
		   progname);
	  exit (EXIT_FAILURE);
	}
      if ((my.mytype == HTTP_CONNECT_AUTH)
	  || (my.mytype == SOCKS5_CONNECT_AUTH))
	{
	  if (set_myuserpass == 0)
	    {
	      fprintf (stderr, "Too few config:myuserpass isn't set\n");
	      exit (EXIT_FAILURE);
	    }
	}
    }
  else
    {
      fprintf (stderr, "mytype:DIRECT is not supported now\n");
      exit (EXIT_FAILURE);
    }

  /* http://$target_host:$target_port$target_path */
  p = strstr (target.target, "http://");
  if (p == NULL)
    {
      fprintf (stderr, "no http:// found in %s\n", target);
      exit (EXIT_FAILURE);
    }
  p += strlen ("http://");
  q = strchr (p, ':');
  if (q == NULL)
    {
      fprintf (stderr, "no : found in %s\n", p);
      exit (EXIT_FAILURE);
    }
  stringlen = q - p;
  target.target_host = xmalloc (stringlen + 1);
  memmove (target.target_host, p, stringlen);
  target.target_host[stringlen] = '\0';
  /* move p after ':' */
  p = q + 1;
  q = strchr (p, '/');
  if (q == NULL)
    {				/* add fix in the future */
      fprintf (stderr, "no / found in %s\n", p);
      exit (EXIT_FAILURE);
    }
  stringlen = q - p;
  target.target_port = xmalloc (stringlen + 1);
  memmove (target.target_port, p, stringlen);
  /* fprintf(stderr,"%d %s %s\n",stringlen,p,q); */
  target.target_port[stringlen] = '\0';

  /* path */
  stringlen = strlen (q);
  target.target_path = xmalloc (stringlen + 1);
  memmove (target.target_path, q, stringlen);
  target.target_path[stringlen] = '\0';

  /*sscanf ((const char *) target, "http://%[^:]:%[^/]%s", target_host,
     target_port, target_path); */

  printf ("setting:\n"
	  "\ttarget=%s\n"
	  "\ttarget_host=%s\n"
	  "\ttarget_port=%s\n"
	  "\ttarget_path=%s\n"
	  "\tkey=%s\n"
	  "\tmethod=%d\n"
	  "\tthreads=%d\n"
	  "\tuser_agent=%s\n"
	  "\ttestconreplysize=%d\n"
	  "\ttesttagreplysize=%d\n",
	  target.target, target.target_host, target.target_port,
	  target.target_path, target.key, test.method, threads, user_agent,
	  test.testconreplysize, test.testtagreplysize);
  switch (my.mytype)
    {
      /*case DIRECT:
         printf("\tmytype=DIRECT\n");
         break; */
    case HTTP_CONNECT:
      printf ("\tmytype=HTTP_CONNECT\n");
      printf ("\tmyhost=%s\n\tmyport=%d\n", my.myhost, my.myport);
      break;
    case HTTP_CONNECT_AUTH:
      printf ("\tmytype=HTTP_CONNECT_AUTH\n");
      printf ("\tmyhost=%s\n\tmyport=%d\n", my.myhost, my.myport);
      printf ("\tmyusepass=%s\n", my.myuserpass);
      break;
    default:
      printf ("\tinvalid mytype:%d\n", my.mytype);
      break;
    }
}

/* read the int after flagstring  */
int
readint (char *line, char *flagstring, int *i, int *num)
{
  if (!strncmp (line, flagstring, strlen (flagstring)))
    {
      *i = atoi (line + strlen (flagstring));
      (*num)++;
      return 0;
    }
  return -1;
}

/* store  string after flagstring to *s */
int
readstr (char *line, char *flagstring, char **s, int *num)
{
  int flagsize, len;
  flagsize = strlen (flagstring);

  if (!strncmp (line, flagstring, flagsize))
    {
      /* duplication */
      if (*num)
	{
	  if (*s)
	    free (*s);
	}

      len = strlen (line) - flagsize + 1;
      *s = xmalloc (len);
      memmove (*s, line + flagsize, len);
      (*num)++;
      return 0;
    }
  return -1;
}

/* copy string after flagstring if length+1 <= stringsize */
int
readstr_old (char *line, char *flagstring, unsigned char *s, int stringsize,
	     int *num)
{
  int flagsize = strlen (flagstring);
  if (!memcmp (line, flagstring, flagsize))
    {
      int len = strlen (line + flagsize) + 1;	/*including trailling \0 */
      if (len > stringsize)
	{
	  fprintf (stderr, "%s size too long:>%d", flagstring, stringsize);
	  exit (EXIT_FAILURE);
	}
      memmove (s, line + flagsize, len);
      (*num)++;
      return 0;
    }
  return -1;
}
