/* Main loop.
 *
 * Copyright (C) 2005 Jia Wang (skyroam@gmail.com)
 *
 *
 *
 * This file is part of phc.
 * Phc is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 2 of the License, or (at your 
 * option) any later version.
 *
 * Phc is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with Phc; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* all functions are declared in phc.h */
#include <phc.h>
pthread_mutex_t counter_mutex_in = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t counter_mutex_out = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t counter_mutex_create = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t counter_mutex_malloc = PTHREAD_MUTEX_INITIALIZER;
#include <sys/time.h>

/* functions defined in this file */
int READAPROXY (struct thread_mem *thread_mem);
int
CONNECTVIA (int sockfd, struct timeval *start,
	    struct timeval *end, struct thread_mem *thread_mem);
int GET (int sockfd, struct timeval *send, struct thread_mem *thread_mem);
int
CONN (int sockfd, struct timeval *start, struct timeval *end,
      struct timeval *req, struct thread_mem *thread_mem);
int VERIFY (int sockfd, struct timeval *finddata,
	    struct timeval *findkey, struct thread_mem *thread_mem);


/* top function defined in this file */
void *
loop (void *arg)
{
  int read, sockfd;

  struct thread_mem loop_mem;
  /* struct queue queue; */
  struct timeval start_via, end_estab, start_GET, enter_data, enter_key;
  struct timeval start_CONN, end_CONN;

  thread_mem_init (&loop_mem);
  while (1)
    {
      /* read loop_mem.queue.testproxy */
      read = READAPROXY (&loop_mem);
      if (read == -1)
	break;			/* end of file */
      if (read == -2)
	continue;
      /* create socket */
      if ((sockfd = socket (AF_INET, SOCK_STREAM, 0)) == -1)
	{
	  fprintf (stderr, "thread %d---", *((int *) arg));
	  perror ("create socket");
	  break;		/* fatal thread error. */
	}
      printf ("thread %d Checking %s\n", *(int *) arg,
	      loop_mem.queue.testproxy);
      /* connect to testproxy (via myproxy now) */
      if (CONNECTVIA (sockfd, &start_via, &end_estab, &loop_mem) == -1)
	goto loop_ex;
      /* protocol will be added here in the future */

      switch (test.method)
	{
	case HTTP_GET:
	  if (GET (sockfd, &start_GET, &loop_mem) == -1)
	    break;
	  /* goto loop_ex; */

	  /* verify the result */
	  if (VERIFY (sockfd, &enter_data, &enter_key, &loop_mem) == 0)
	    {
	      printf ("Thread %d--Found!!!!!!%s delay=%f %f %f\n",
		      *((int *) arg), loop_mem.queue.testproxy,
		      time_sub (end_estab, start_via), time_sub (enter_data,
								 start_GET),
		      time_sub (enter_key, enter_data));
	      pthread_mutex_lock (&counter_mutex_out);
	      fprintf (out, "%s@HTTP\t%f %f %f\n",
		       loop_mem.queue.testproxy,
		       time_sub (end_estab, start_via),
		       time_sub (enter_data, start_GET),
		       time_sub (enter_key, enter_data));
	      pthread_mutex_unlock (&counter_mutex_out);
	    }
	  break;
	case HTTP_CONNECT:
	  if (CONN (sockfd, &start_CONN, &end_CONN, &start_GET, &loop_mem) ==
	      -1)
	    goto loop_ex;
	  if (VERIFY (sockfd, &enter_data, &enter_key, &loop_mem) == 0)
	    {
	      printf ("Thread %d--Found!!!!!%s delay=%f %f %f %f\n",
		      *((int *) arg), loop_mem.queue.testproxy,
		      time_sub (end_estab, start_via), time_sub (enter_data,
								 start_GET),
		      time_sub (enter_key, enter_data), time_sub (end_CONN,
								  start_CONN));
	      fprintf (out, "%s@HTTP %f %f %f %f\n", loop_mem.queue.testproxy,
		       time_sub (end_estab, start_via), time_sub (enter_data,
								  start_GET),
		       time_sub (enter_key, enter_data), time_sub (end_CONN,
								   start_CONN));
	    }
	  break;
	default:		/* not necessay,should be done in init */
	  fprintf (stderr, "error:unknown method!\n");
	  break;
	}
    loop_ex:
      close (sockfd);
    }
  return arg;
}



/* thread order: *((int *)arg) */
int
READAPROXY (struct thread_mem *thread_mem)
{
  int mlen = 80;
  int read;

  thread_mem->line = NULL;
  /* read a line into thread_mem->line */
  pthread_mutex_lock (&counter_mutex_in);
  read = getaline_r ((char **) &(thread_mem->line), &mlen, in, thread_mem);
  pthread_mutex_unlock (&counter_mutex_in);

  if (read == -1)		/* not memory errors */
    {
      if (thread_mem->line)
	pxfree ((void **) &(thread_mem->line));
      return -1;
    }				/* read = -1(end of file or stop after errors) or >=1, will not be 0 */
  if (*(thread_mem->line + read - 1) == '\n')
    *(thread_mem->line + read - 1) = '\x0';
  /* debug */
  fprintf (stderr, "Parsing %d bytes: %s\n", read - 1, thread_mem->line);
  /* read to testproxy, return -2 when data invalid */
  /* save into thread_mem->queue.testproxy from thread_mem->line if success */
  if (checkaline (in, thread_mem) == -1)
    {
      read = -2;
    }
  else
    {
      fprintf (stderr, "Testproxy=%d len: %s\n",
	       strlen (thread_mem->queue.testproxy),
	       thread_mem->queue.testproxy);
    }

  if (thread_mem->line)
    pxfree ((void **) &(thread_mem->line));
  return read;			/* -1 means end of file */

}

int
CONNECTVIA (int sockfd, struct timeval *start,
	    struct timeval *end, struct thread_mem *thread_mem)
{
  int ret, len, offset;
  char *p;


  /* if mytype == direct 
     parse(testproxy);(strtok)
     gettimeofday
     ret = connect(testhost,testport)
     gettimeofday
     if( ret == 0) return 0;
     else return -1;
   */
  ret =
    connect (sockfd, (struct sockaddr *) &(my.myaddr),
	     sizeof (struct sockaddr));
  if (ret == -1)
    {
      perror ("connect to myaddr");
      return -1;
    }

  /* build request */
  if (my.mytype == HTTP_CONNECT_AUTH)
    {
      len =
	strlen ("CONNECT  HTTP/1.0") + strlen (thread_mem->queue.testproxy) +
	2 + strlen (user_agent) + 2 + strlen (NOCACHE) + 2 +
	strlen ((const char *) my.header_auth) + 2 + 2;

      thread_mem->request = pxmalloc ((len + 1), thread_mem);
      snprintf (thread_mem->request, len + 1,
		"CONNECT %s HTTP/1.0\r\n"
		"%s\r\n"
		"%s\r\n"
		"%s\r\n" "\r\n", thread_mem->queue.testproxy, user_agent,
		NOCACHE, my.header_auth);

    }
  else
    {
      len =
	strlen ("CONNECT  HTTP/1.0") + strlen (thread_mem->queue.testproxy) +
	2 + strlen (user_agent) + 2 + strlen (NOCACHE) + 2 + 2;
      thread_mem->request = pxmalloc ((len + 1), thread_mem);

      snprintf (thread_mem->request, len + 1,
		"CONNECT %s HTTP/1.0\r\n"
		"%s\r\n" "%s\r\n" "\r\n", thread_mem->queue.testproxy,
		user_agent, NOCACHE);
    }

  *((thread_mem->request) + len) = '\0';

  /* send */
  gettimeofday (start, NULL);
  ret = write (sockfd, thread_mem->request, strlen (thread_mem->request));

  if (ret != strlen (thread_mem->request))
    {
      fprintf (stderr, "CONVIA--write:\n");
      if (ret == -1)
	perror ("CONVIA--write--perror");
      pxfree ((void **) &(thread_mem->request));
      return -1;
    }
  else
    pxfree ((void **) &(thread_mem->request));

  /* read estab string */
  thread_mem->reply = pxmalloc (my.myconreplysize, thread_mem);

  memset (thread_mem->reply, 0, my.myconreplysize);
  p = thread_mem->reply;

  while (1)
    {

      offset = p - thread_mem->reply;
      ret = read (sockfd, p, my.myconreplysize - offset - 1);
      if (ret <= 0)
	{
	  break;
	}
      /* repaired */
      gettimeofday (end, NULL);
      /* if(ret < strlen(CONNECT_SUCCESS))return -1; */
      if ((strstr (thread_mem->reply, CONNECT_SUCCESS0) != NULL)
	  || (strstr (thread_mem->reply, CONNECT_SUCCESS1) != NULL))
	{
	  pxfree ((void **) &(thread_mem->reply));
	  return 0;
	}
      p += ret;
      if ((p - thread_mem->reply) >= (my.myconreplysize - 1))	/* == is ok,ret <= readsize */
	break;			/* too long */
    }
  /* too long or read return 0/-1 */
  fprintf (stderr, "reply to convia is wrong:%s\n", thread_mem->reply);
  pxfree ((void **) &(thread_mem->reply));
  return -1;
}

int
GET (int sockfd, struct timeval *send, struct thread_mem *thread_mem)
{
  int numbytes, len;

  /* build request string */
  len = strlen ("GET  HTTP/1.0") + strlen (target.target) + 2 +
    strlen ("Host: ") + strlen (target.target_host) + 2 +
    strlen (user_agent) + 2 + strlen (NOCACHE) + 2 + 2;

  thread_mem->request = pxmalloc (len + 1, thread_mem);

  snprintf (thread_mem->request, len + 1, "GET %s HTTP/1.0\r\n" "Host: %s\r\n" "%s\r\n%s\r\n" "\r\n", target.target, target.target_host, user_agent, NOCACHE);	/* remove header_auth! */

  thread_mem->request[len] = '\0';

  /* send */
  gettimeofday (send, NULL);
  numbytes =
    write (sockfd, thread_mem->request, strlen (thread_mem->request));

  pxfree ((void **) &(thread_mem->request));

  if (numbytes != len)
    {
      fprintf (stderr, "GET--write:\n");
      if (numbytes < 0)
	perror ("GET--write");
      return -1;		/* ... */
    }

  return numbytes;
}

int
CONN (int sockfd, struct timeval *start, struct timeval *end,
      struct timeval *req, struct thread_mem *thread_mem)
{
  int numbytes, len;
  char *p;
  /* build request string */
  len = strlen ("CONNECT : HTTP/1.0") + strlen (target.target_host) +
    strlen (target.target_port) + 2 +
    strlen ("Host: ") + strlen (target.target_host) + 2 +
    strlen (user_agent) + 2 + strlen (NOCACHE) + 2 + 2;
  thread_mem->request = pxmalloc (len + 1, thread_mem);
  snprintf (thread_mem->request, len + 1, "CONNECT %s:%s HTTP/1.0\r\n" "Host: %s\r\n" "%s\r\n%s\r\n" "\r\n", target.target_host, target.target_port, target.target_host, user_agent, NOCACHE);	/* remove header_auth! */

  thread_mem->request[len] = '\0';
  /* send */
  gettimeofday (start, NULL);
  numbytes =
    write (sockfd, thread_mem->request, strlen (thread_mem->request));
  pxfree ((void **) &(thread_mem->request));
  if (numbytes != len)
    {
      fprintf (stderr, "CONCON-writecon:\n");
      if (numbytes < 0)
	perror ("CONCON-writecon");
      return -1;		/* ... */
    }

  /* read estab string */
  thread_mem->reply = pxmalloc (test.testconreplysize, thread_mem);
  memset (thread_mem->reply, 0, test.testconreplysize);
  p = thread_mem->reply;
  while (1)
    {
      numbytes =
	read (sockfd, p, test.testconreplysize - (p - thread_mem->reply) - 1);

      /* need repaired */
      gettimeofday (end, NULL);

      if (numbytes <= 0)
	{
	  fprintf (stderr, "reply to concon is wrong:%s\n",
		   thread_mem->reply);
	  pxfree ((void **) &(thread_mem->reply));
	  return -1;
	}
      /* if(numbytes < strlen(CONNECT_SUCCESS))return -1; */
      if ((strstr (thread_mem->reply, CONNECT_SUCCESS0) != NULL)
	  || (strstr (thread_mem->reply, CONNECT_SUCCESS1) != NULL))
	break;
      p += numbytes;
      if ((p - thread_mem->reply) == test.testconreplysize - 1)
	{
	  thread_mem->reply[test.testconreplysize] = '\0';	/* no need ! */
	  fprintf (stderr, "reply to concon is wrong:%s\n",
		   thread_mem->reply);
	  pxfree ((void **) &(thread_mem->reply));
	  return -1;
	}
    }

  pxfree ((void **) &(thread_mem->reply));

  /* send req */
  len = strlen ("GET  HTTP/1.0") + strlen (target.target_path) + 2 +
    strlen ("Host: ") + strlen (target.target_host) + 2 +
    strlen (user_agent) + 2 + strlen (NOCACHE) + 2 + 2;
  thread_mem->request = pxmalloc (len + 1, thread_mem);

  snprintf (thread_mem->request, len + 1,
	    "GET %s HTTP/1.0\r\n"
	    "Host: %s\r\n"
	    "%s\r\n%s\r\n"
	    "\r\n", target.target_path, target.target_host, user_agent,
	    NOCACHE);
  gettimeofday (req, NULL);
  numbytes =
    write (sockfd, thread_mem->request, strlen (thread_mem->request));
  pxfree ((void **) &(thread_mem->request));
  if (numbytes != len)
    {
      fprintf (stderr, "concon-writereq:\n");
      if (numbytes < 0)
	perror ("concon-writereq");
      return -1;		/* ... */
    }
  return numbytes;
}

int
VERIFY (int sockfd, struct timeval *finddata,
	struct timeval *findkey, struct thread_mem *thread_mem)
{
  int numbytes;
  char *p;			/* danger? */
  int t = 0;

  thread_mem->reply = pxmalloc (test.testtagreplysize, thread_mem);
  p = thread_mem->reply;
  memset (p, 0, test.testtagreplysize);
  /* -1 for \0 ->strstr */
  while (1)
    {
      numbytes =
	read (sockfd, p, test.testtagreplysize - (p - thread_mem->reply) - 1);
      if (numbytes <= 0)
	{

	  pxfree ((void **) &(thread_mem->reply));
	  return -1;
	}
      t++;
      if (t == 1)
	gettimeofday (finddata, NULL);
      /* printf("RETURN!!!!!!!!!!!!!!!%s",buf); */

      gettimeofday (findkey, NULL);	/* save time */
      if (strstr (thread_mem->reply, target.key) != NULL)
	{
	  /* gettimeofday (findkey, NULL); */
	  pxfree ((void **) &(thread_mem->reply));
	  return 0;
	}
      p += numbytes;
      if ((p - thread_mem->reply) == (test.testtagreplysize - 1))
	{
	  pxfree ((void **) &(thread_mem->reply));
	  return -1;
	}
    };
  /* return -1; */
}
