/*
 * Copyright (C) 2005 Jia Wang (skyroam@gmail.com)
 *
 *
 *
 * This file is part of phc.
 * Phc is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 2 of the License, or (at your 
 * option) any later version.
 *
 * Phc is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with Phc; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* all upper case */
#include <phc.h>
#include <string.h>
#include <stdio.h>
int
checkaline (FILE * in, struct thread_mem *thread_mem)
{
  char *p;
  size_t plen;
    /**************deal with proxylistline************/
  p = strchr (thread_mem->line, '@');
  if (p == NULL)
    {
      fprintf (stderr, "testproxy is in invalid format:%s\n",
	       thread_mem->line);
      return -1;
    }
  plen = p - thread_mem->line;
  if (plen < strlen ("1.2.3.4:8"))
    {
      fprintf (stderr, "invalid testproxy:%s\n", thread_mem->line);
      return -1;
    }
  p++;

  if ((strncmp (p, "HTTP", 4) != 0) && (strncmp (p, "http", 4) != 0))
    {
      fprintf (stderr, "%s...%sunsupported\n", thread_mem->line, p);
      return -1;
    }


  thread_mem->queue.testproxy = pxmalloc (plen + 1, thread_mem);
  memmove (thread_mem->queue.testproxy, thread_mem->line, plen);
  /* though it is not necessay now */
  *(thread_mem->queue.testproxy + plen) = '\0';
  return 0;
}
