/*
 * testprograma.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \file testprograma.c
 *  \brief Test de las funciones mas problemáticas de la biblioteca.
 *
 *  \author Fernando Pujaico Rivera
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <pds/pdsit.h>
#include <pds/pdsra.h>
#include <pds/pdsmath.h>
#include <math.h>

/** \example testprograma.c
 *  \author Fernando Pujaico Rivera
 *  \date 18-04-2015
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *  
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 */
int main(int argc, char** argv)
{
	double Hjoint;
	double Hjoint2;
	double Hcond;
	double Hcond2;
	double rho;
	double rho0;
	double BER;
	int i;

	PdsVector *Ps=NULL;

	int M=7;

	Ps=pds_vector_new(M);
	
	for(i=0;i<M;i++)
	{
		pds_vector_set_value (Ps, (PdsRaNatural)i,0.1+i/(4.0*M));
	}
	printf("\nPS:\n");
	pds_vector_printf(Ps);

	printf("\n");

	pds_joint_entropy_bsc_model(Ps,0.5,&Hjoint);
	printf("H(Omega)    :\t%f\n",Hjoint);

	pds_inv_symetric_joint_entropy_bsc_model(Hjoint,M,&rho);
	printf("rho         :\t%f\n",rho);

	pds_symetric_joint_entropy_bsc_model(rho,M,&Hjoint2);
	printf("H(rho,M)    :\t%f\n",Hjoint2);

	printf("\n");

	pds_entropy_u0_omega_bsc_model(Ps,0.5,&Hcond);
	printf("H(U0|Omega) :\t%f\n",Hcond);

	pds_inv_symetric_entropy_u0_omega_bsc_model(Hcond,M,&rho0);
	printf("rho0        :\t%f\n",rho0);

	pds_symetric_entropy_u0_omega_bsc_model(rho0,M,&Hcond2);
	printf("H(U0|rho0,M):\t%f\n",Hcond2);

	pds_symetric_ber_bsc_model(rho,M,&BER);
	printf("BER(rho0,M)  :\t%f\n",BER);
	printf("pds_hb(BER) :\t%f\n",pds_hb(BER));

	printf("\n");

	return EXIT_SUCCESS;
}


