package otests.matrix.BandLU;

import opale.tools.*;
import opale.mathtools.*;
import opale.matrix.*;
import opale.matrix.solver.*;


public class BandLU implements OTest
{
public  void run(String path)
	{
	int size = 100;
	BandMatrix A = new BandMatrix (size,3);

	for (int i=0;i<size;i++)
		{
		A.set(i,i,2);
		if (i>0) A.set(i,i-1,-7);
		if (i<size-1) A.set(i,i+1,-7);
		 }
	//System.out.println(A);
	//System.out.println(A.get(2,2));
	
	DVect b=new DVect(size);
	DVect x=new DVect(size);

	
	b.set(0,1);
	b.set(1,0);
	
	
	BandMatrix AA = (BandMatrix) A.clone();	 
	SolverLUBand lu = new SolverLUBand();
	lu.decomp(A);
	//System.out.println(A);
	System.out.println("det = "+lu.determinant());
	lu.solve(null,b,x);
	//System.out.println(x);

	
	
	DVect err = new DVect(size);
	DVect Ax = new DVect(size);
	Ax = AA.mul(x);
	for (int i=0;i<size;i++)
		{
		err.set(i,Ax.get(i)-b.get(i));
		}
	
	System.out.println("Err = "+err.getMax());
	
	}
public void stop()
	{
	}
	
}
	
