package opale.ode.scheme;

import opale.mathtools.*;
import opale.ode.*;


/**
* Cette classe implmente le schma de Runge Kutta classique qui consiste  avancer en temps de la facon suivante : ***.
* @author O.C.
* @since Opale-ODE 0.1
*/
public final class RK extends TimeScheme
{
/**
* Cette mthode dfinit l'avanc en temps par la formule de Runge Kutta classique.
*/	
public void forward(Equation eq)
	{
	DVect tempo = new DVect(present().size());
	int i;
	double dt2 = 0.5*dt();

	DVect der = eq.derivs(time(),present());
	for (i=0;i<present().size();i++)
		tempo.set(i,present().get(i)+dt2*der.get(i));

	DVect der2 = eq.derivs(time()+dt2,tempo);
	for (i=0;i<present().size();i++)
		tempo.set(i,present().get(i)+dt2*der2.get(i));
	
	DVect der3 = eq.derivs(time()+dt2,tempo);
	for (i=0;i<present().size();i++)
		tempo.set(i,present().get(i)+dt()*der3.get(i));
	 DVect der4 = eq.derivs(time()+dt(),tempo);
	
	
	for (i=0;i<present().size();i++)
		{
		present().set(i,present().get(i)+dt()*((der.get(i)+der4.get(i))/6+(der2.get(i)+der3.get(i))/3));
		}
	}

public String toString()
	{
	return "RK";
	}

}
