package opale.ode.scheme;

import opale.mathtools.*;
import opale.ode.*;


/**
* Cette classe implmente le schma d'Heun.
* @author O.C.
* @since Opale-ODE 0.1
*/
public final class Heun extends TimeScheme
{
private double temp;
/**
* Cette mthode dfinit l'avanc en temps par la formule de Heun.
*/	
public void forward(Equation eq)
	{
	DVect tmp = new DVect(present().size());
	int i;
	DVect der = eq.derivs(time(),present());
	for (i=0;i<present().size();i++)
		tmp.set(i,present().get(i)+dt()*der.get(i));
	DVect der2 = eq.derivs(time()+dt(),tmp);
	for (i=0;i<present().size();i++)
		{
		present().set(i,present().get(i)+0.5*dt()*(der.get(i)+der2.get(i)));

		}
	}

public String toString()
	{
	return "Heun";
	}

}
