/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.matrix.solver;

import opale.tools.Debug;
import opale.mathtools.DVect;
import opale.matrix.*;

/**
* This class implements Crout decomposition according to the book "Analyse matricielle applique  l'art de l'ingnieur", Lascaux & Thodor, Ed. Masson. (without pivot ->> instable !!)
* @author O.C.
* @date 04/2001
* @since Opale-matrix 0.11
*/


public class SolverCrout implements SymSolver, SymDecomposition
{

private double[] LD;
private int[] pivot;
private int n,signepermut;

public void decomp(SymMatrix A)
	{
	n = A.getDim();
	int  jmax,tmp;
	int cpti,cptj;
	
	
	if (Decomposition.REPLACE) LD=A.getInternalArray();
	else LD = A.getArrayCopy();
	
		
	for (int i=0;i<n;i++)
		{
		cpti = i*(i+1)/2;
		int diagi = cpti+i;
			
		for (int j=0;j<i;j++)
			{
			int dum=j*(j+1)/2;
			cptj = cpti+j;
			for(int k=0,cptk = cpti;k<j;k++,cptk++,dum++)
				LD[cptj] -= LD[cptk]*LD[dum];
			}
		for (int j=0;j<i;j++)
			{
			cptj = cpti+j;
			double s = LD[cptj]/LD[j*(j+1)/2+j];
			LD[diagi]-= s*LD[cptj];
			LD[cptj] =s;
			}
		}
	}


/**
* Solve LDL^t x=b.
* @param Matrix A, not used.
*/
public void solve(SymMatrix A,DVect b, DVect x)
	{
	int cpti,dum;
	double[] B = b.toArray();
	double[] X = x.toArray();

	for (int i=0;i<n;i++)
		{
		cpti = i*(i+1)/2;
		X[i] = B[i];
		for (int j=0;j<i;j++) X[i]-=LD[cpti++]*X[j];
		}

	for (int i=0;i<n;i++)
		X[i]/=LD[i*(i+1)/2+i];

/*	for (int i=n-1;i>=0;i--)
		{
		cpti =  (i+1)*i/2+i;
		for (int j=i+1;j<n;j++) { cpti+=j; X[i]-=LD[cpti]*X[j]; } 
		}*/
	for (int j=n-1;j>=0;j--)
		{
		cpti =  (j+1)*j/2;
		for (int i=0;i<j;i++,cpti++) {  X[i]-=LD[cpti]*X[j]; } 
		}
	
		
	}
	
/** 
* Compute the determinant : product of D[i][i]
* @return     double, the determinant
*/
public double determinant() 
	{
	double det = 1;;
	for (int i = 0; i < n; i++) 
		det *= LD[i*(i+1)/2+i];

	return det;
	}

public static void main(String[] arg)
	{
	SymMatrix A = new SymMatrix(3);
	DVect b=new DVect(3);
	DVect x=new DVect(3);

	A.set(0,0,2);

	A.set(1,0,1);
	A.set(1,1,1);

	//A.set(2,0,1);
	//A.set(2,1,1);
	A.set(2,2,3);

	b.set(0,1);
	b.set(1,-1.5);
	b.set(2,3);
	System.out.println(A);
	
	SolverCrout crout = new SolverCrout();
	crout.decomp(A);
	crout.solve(null,b,x);
	System.out.println(A);
	System.out.println(x);
	System.out.println("det = "+crout.determinant());
	}
	
			
}
	
	

