package opale.mathtools.parser;


class PNode extends Object {
        public static final int NULL     = -1;
        public static final int OP          = 0;
        public static final int VALUE       = 1;
        public static final int FUNCTION   = 2;
        public static final int VAR = 3;
        public static final int PARAMETER   = 4;
        
        PNode left;
        PNode right;
        double value;
        int op;
        int type;
        String svalue;
  
        
        public PNode() {
            type = NULL;
            left = null;
            right = null;
            op = NULL;
            value = 0.0;
	    svalue="";
        } 
        
         public PNode(PNode n) {
            replace(n);
         }

         public void replace(PNode n ) {
            if(n == null) return;
            op          = n.op;
            type        = n.type;
            left        = n.left;
            right       = n.right;
            value       = n.value;
            svalue       = new String(n.svalue);
        }

         public void indent(int ind) {
              for (int i = 0; i < ind; i++) System.out.print(" ");
        }

        public void print(int indentLevel) {
           char l[] = new char[1];
           indent(indentLevel);
           System.out.println("NODE type=" + type);
           indent(indentLevel);
           switch (type) {
              case PNode.VALUE:
                 System.out.println("     value=" + value);
                 break;
              case PNode.FUNCTION:
                 System.out.println("     svalue=" + svalue);
                 break;
              case PNode.VAR:
                 System.out.println("     variable=" + svalue);
                 break;
              default:
                 System.out.println("     op=" + (char)op);
                 if(left  != null) left.print(indentLevel + 5);
                 if(right != null) right.print(indentLevel + 5);
                 break;
           }
        }
         
}
