package opale.mathtools.parser;


class Sin extends UnaryFunction { public double eval(double x) { return Math.sin(x); } 
				 public String keyword() { return "sin"; } }
				 
class Cos extends UnaryFunction { public double eval(double x) { return Math.cos(x); } 
				 public String keyword() { return "cos"; } }
				 
class Tan extends UnaryFunction { public double eval(double x) { return Math.tan(x); } 
				 public String keyword() { return "tan"; } }
				 
class Log extends UnaryFunction { public double eval(double x) { return Math.log(x); } 
				 public String keyword() { return "log"; } }
				 
class Log10 extends UnaryFunction { public double eval(double x) { return Math.log(x)/Math.log(10);  }
				 public String keyword() { return "log10"; } }
				 
class Exp extends UnaryFunction { public double eval(double x) { return Math.exp(x); } 
				 public String keyword() { return "exp"; } }
				 
class Sqrt extends UnaryFunction { public double eval(double x) { return Math.sqrt(x); } 
				 public String keyword() { return "sqrt"; } }
				 
class Abs extends UnaryFunction { public double eval(double x) { return Math.abs(x); } 
				 public String keyword() { return "abs"; } }

class Acos extends UnaryFunction { public double eval(double x) { return Math.acos(x); } 
				 public String keyword() { return "acos"; } }
				 
class Asin extends UnaryFunction { public double eval(double x) { return Math.asin(x); } 
				 public String keyword() { return "asin"; } }
				 
class Atan extends UnaryFunction { public double eval(double x) { return Math.atan(x); } 
				 public String keyword() { return "atan"; } }
				 
class Rnd extends UnaryFunction { public double eval(double x) { return Math.random()*x; } 
				 public String keyword() { return "rnd"; } }
				 
class Rad extends UnaryFunction { public double eval(double x) { return Math.toRadians(x); } 
				 public String keyword() { return "rad"; } }
				 
class Deg extends UnaryFunction { public double eval(double x) { return Math.toDegrees(x); } 
				 public String keyword() { return "deg"; } }
				 

