/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.mathtools;

/**
* <code>Sort</code> is the superclass of sorting methods.
* @author O.C.
* @date 01/2001
* @since Opale-Mathtools 0.11
*/
public abstract class Sort
{

/**
* Gets the maximum element of an array of <code>double</code>
* @param int n, the size of the array.
* @param double[] tab, the array.
* @return double, the maximum.
*/
public final static double getMax(int n, double[] tab)
	{
	double max;
	
	max = tab[--n];
	for (;n>=0;n--)
		if (tab[n] > max) max = tab[n];
	return max;
	}

/**
* Gets the minimum element of an array of <code>double</code>
* @param int n, the size of the array.
* @param double[] tab, the array.
* @return double, the minimum.
*/
public final static double getMin(int n, double tab[])
	{
	double min;
	
	min=tab[--n];
	for (;n>=0;n--)
		if (tab[n] < min) min = tab[n];
	return min;
	}
/**
* Abstract method to sort an array 'tab' into ascending numerical order.
* @param int n, the size of the array.
* @param double[] tab, the array.
*/
abstract public void sort(int n, double[] tab);


}

