/*
Copyright (C) 2000  Groupe Opale

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d;

import opale.tools.*;
import java.util.*;
import java.io.StreamTokenizer;

/**
* Cette classe permet de contenir un certain nombre d'objets de type <code> Object2D</code> et de repres de type <code>OIJ</code>.
* Elle permet ainsi de tracer tous ces objets avec l'appel unique  la mthode <code>draw(Pen2D c)</code>, de suavegarder ces objets dans un fichier dde donnes et de les relire.
* @since Opale-2d 0.15, Elle tend la classe OpaleSet 
* @author O.C.
* @since Opale-2d 0.1
*/

public class Pack2D extends OpaleSet
{
private Legend legend;
public Pack2D()
	{
	super();
	legend = new Legend(this);

	
	}
/**
* Retourne l'instance de la lgende associ  ce pack.
* @return Legend, la lgende.
* @since Opale-2d 0.11
*/
public Legend legend()
	{
	return legend;
	}
	

/**
* Dessine tous les objets contenus dans le pack.
* @param Pen2D c, l'instance de Pen2D pour dessiner.
*/
public void draw(Pen2D c)
	{
	int i;
	OpaleObject obj;
	legend.draw(c);
	Collection col = objects();
	Iterator it = col.iterator();
	while (it.hasNext())
		{
		obj = (OpaleObject) it.next();
		if ( obj instanceof GObject2D )
			{
			GObject2D ob = (GObject2D) obj;
			c.draw(ob);
			}
		}
	}
}
