/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import opale.m2d.OIJ;
import opale.tools.Debug;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleObject;
import opale.tools.OpaleSet;

public abstract class Object2D
extends OpaleObject
implements Cloneable {
    private OIJ rep;

    public Object2D() {
        this.rep = OIJ.OIJ_ABSOLUTE;
    }

    public Object2D(OIJ oIJ) {
        this.rep = oIJ;
    }

    public void setOIJ(OIJ oIJ) {
        this.rep = oIJ;
    }

    public OIJ getOIJ() {
        return this.rep;
    }

    public Object clone() {
        Object2D object2D = (Object2D)super.clone();
        object2D.rep = this.rep;
        return object2D;
    }

    public abstract void changeOIJ(OIJ var1);

    public abstract String toString();

    public void write(PrintWriter printWriter, OpaleSet opaleSet) throws InvalidFormatException {
        printWriter.println("{");
        if (!opaleSet.contains(this.getOIJ())) {
            throw new InvalidFormatException("Error writing the file " + printWriter + " : the OIJ " + this.getOIJ() + " doesn't exist !!");
        }
        printWriter.println("OIJ " + this.getOIJ().getId());
        this.writeMore(printWriter, opaleSet);
        printWriter.println("}");
    }

    public abstract void writeMore(PrintWriter var1, OpaleSet var2) throws InvalidFormatException;

    public void read(StreamTokenizer streamTokenizer, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        OIJ oIJ = null;
        int n = streamTokenizer.nextToken();
        if (n != -3 || !streamTokenizer.sval.equals("{")) {
            throw new InvalidFormatException("Data file " + streamTokenizer + " is wrong !!");
        }
        n = streamTokenizer.nextToken();
        do {
            if (n != -3) {
                throw new InvalidFormatException("Data file " + streamTokenizer + " is wrong : we want a keyword !!");
            }
            if (streamTokenizer.sval.equals("OIJ")) {
                n = streamTokenizer.nextToken();
                if (n != -3) {
                    throw new InvalidFormatException("Data file " + streamTokenizer + " is non valid  : error reading an OIJ");
                }
                Debug.print("Dans Object2D : " + opaleSet.contains(streamTokenizer.sval));
                Debug.print("Dans Object2D : " + opaleSet.getObject(streamTokenizer.sval));
                if (!opaleSet.contains(streamTokenizer.sval) || opaleSet.getObject(streamTokenizer.sval) == null) {
                    throw new InvalidFormatException("Data file " + streamTokenizer + " is wrong  : the identifiant " + streamTokenizer.sval + " doesn't exist !!");
                }
                if (opaleSet.getObject(streamTokenizer.sval) instanceof OIJ) {
                    oIJ = (OIJ)opaleSet.getObject(streamTokenizer.sval);
                    continue;
                }
                throw new InvalidFormatException("Data file " + streamTokenizer + " is non valid  : the identifiant " + streamTokenizer.sval + " is not a OIJ !!");
            }
            if (this.readKeyWord(streamTokenizer.sval, streamTokenizer, opaleSet) != -1) continue;
            throw new InvalidFormatException("Data file " + streamTokenizer + " is non valid   : error reading a keyword " + streamTokenizer.sval + " !!");
        } while ((n = streamTokenizer.nextToken()) != -3 || !streamTokenizer.sval.equals("}"));
        if (oIJ == null) {
            throw new InvalidFormatException("No OIJ for this object !!" + this);
        }
        this.setOIJ(oIJ);
    }

    public double xmax() {
        return 0.0;
    }
}

