/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import opale.m2d.GObject2D;
import opale.m2d.InfoObject;
import opale.m2d.InfoPoint;
import opale.m2d.MarkType;
import opale.m2d.OIJ;
import opale.m2d.Pen2D;
import opale.m2d.Point2D;
import opale.m2d.marktype.ClassicPoint;
import opale.tools.Debug;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleSet;

public class GPoint2D
extends Point2D
implements GObject2D,
Cloneable {
    private InfoPoint info;
    private MarkType markType;

    public GPoint2D() {
        Debug.print("Dans GPoint2D()");
        this.info = new InfoPoint();
        this.markType = new ClassicPoint();
    }

    public GPoint2D(OIJ oIJ) {
        super(oIJ);
        this.info = new InfoPoint();
        this.markType = new ClassicPoint();
    }

    public GPoint2D(OIJ oIJ, double d, double d2) {
        super(oIJ, d, d2);
        this.info = new InfoPoint();
        this.markType = new ClassicPoint();
    }

    public GPoint2D(Point2D point2D) {
        super(point2D);
        this.info = new InfoPoint();
        this.markType = new ClassicPoint();
    }

    public GPoint2D(GPoint2D gPoint2D) {
        super(gPoint2D);
        this.info = new InfoPoint((InfoPoint)gPoint2D.getInfo());
        this.markType = (MarkType)gPoint2D.markType.clone();
    }

    public void draw(Pen2D pen2D) {
        if (this.info.isVisible()) {
            int n = this.info.symbol;
            pen2D.setColor(this.info.getColor());
            this.markType.draw(pen2D, this.x, this.y);
        }
    }

    public InfoObject getInfo() {
        return this.info;
    }

    public Object clone() {
        GPoint2D gPoint2D = (GPoint2D)super.clone();
        gPoint2D.info = (InfoPoint)this.info.clone();
        gPoint2D.markType = (MarkType)this.markType.clone();
        return gPoint2D;
    }

    public int readKeyWord(String string, StreamTokenizer streamTokenizer, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        if (string.equals("INFO")) {
            this.info.read(streamTokenizer, opaleSet);
            return 0;
        }
        if (string.equals("MARK_TYPE")) {
            try {
                int n = streamTokenizer.nextToken();
                if (n != -3) {
                    return -1;
                }
                this.markType = (MarkType)Class.forName(opaleSet.getNameObject(streamTokenizer.sval)).newInstance();
                this.markType.read(streamTokenizer, opaleSet);
                Debug.print("MarkType = ", this.markType.getClass().getName());
                Debug.print("MarkType size = ", this.markType.getMarksize());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InvalidFormatException("Error reading an object of type " + streamTokenizer.sval + " : the class does not exist.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InvalidFormatException("Error reading an object of type " + streamTokenizer.sval + " : access to the class not possible.");
            }
            catch (InstantiationException instantiationException) {
                throw new InvalidFormatException("Error reading an object of type " + streamTokenizer.sval + " : class not instantiable.");
            }
            return 0;
        }
        return super.readKeyWord(string, streamTokenizer, opaleSet);
    }

    public void writeMore(PrintWriter printWriter, OpaleSet opaleSet) throws InvalidFormatException {
        this.info.write(printWriter, opaleSet);
        printWriter.print("MARK_TYPE " + opaleSet.getUserName(this.markType.getClass().getName()) + " ");
        this.markType.write(printWriter, opaleSet);
        super.writeMore(printWriter, opaleSet);
    }

    public void setMarktype(MarkType markType) {
        this.markType = markType;
    }
}

