import os
import polib

# The exact msgids to match
SHORT_MSGID = 'Keep Root Menu Separate in Saved Menu File'
LONG_MSGID = (
    "This menu contained invisible orphaned menus. Since it has just been saved "
    "with the \"Keep Root Menu Separate in Saved Menu File\" option <b>disabled</"
    "b>, these menus have now become part of the root menu and, <b>if they have a "
    "label</b>, are no longer invisible."
)

def normalize_string(s):
    """Normalize string by removing line breaks and excessive whitespace."""
    return ' '.join(s.split())

def check_po_file(filepath):
    po = polib.pofile(filepath)

    short_msgstr = None
    long_msgstr = None

    for entry in po:
        if entry.msgid == SHORT_MSGID:
            short_msgstr = normalize_string(entry.msgstr)
        elif entry.msgid == LONG_MSGID:
            long_msgstr = normalize_string(entry.msgstr)

    if short_msgstr and long_msgstr:
        if short_msgstr not in long_msgstr:
            return True  # Problem found
    return False  # Either no issue or not both msgids present

def main():
# Traverse all files in current directory
    po_dir = os.path.join("..", "..", "po")

    for filename in os.listdir(po_dir):
        if filename.endswith(".po"):
            fpath = os.path.join(po_dir, filename)
            if check_po_file(fpath):
                print(f"Problem in file: {filename}")
                
if __name__ == "__main__":
    main()

