/*
--             This file is part of the New World OS project
--                 Copyright (C) 2005-2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: class_definition.c,v $
-- Revision 1.3  2007/07/01 19:44:13  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.2  2006/12/23 16:34:23  jsedwards
-- Ifdef out create_class function so it won't need a function we don't have.
--
-- Revision 1.1  2006/12/22 14:01:00  jsedwards
-- Copy of 0014 version from root directory.
--
-- Revision 1.7  2006/12/01 14:37:23  jsedwards
-- Fix the year in the copyright.
--
-- Revision 1.6  2006/12/01 14:31:30  jsedwards
-- Changed to use new malloc_reference_list and free_reference_list functions
-- instead of inlining the code.
--
-- Revision 1.5  2006/11/29 18:29:03  jsedwards
-- Fixed bug where memory following class_ref was overwritten if pointers were
-- not the same size as an ObjRef.
--
-- Revision 1.4  2006/11/11 14:19:07  jsedwards
-- Moved find_class_defintion function from objectify.c.
--
-- Revision 1.3  2006/11/11 12:01:01  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.2  2006/10/26 01:51:23  jsedwards
-- Merged alpha_05_branch back into main trunk.
--
-- Revision 1.1.2.2  2006/10/25 12:22:27  jsedwards
-- Changed C_struct_class_definition to C_struct_Class_Definition so the case
-- is consistent with all the other C_struct objects.
--
-- Revision 1.1.2.1  2006/09/01 13:27:20  jsedwards
-- Changed "nwos_object_size" to "nwos_reference_list_size" and added the
-- object reference to "nwos_fill_in_common_header" so it can put the "id"
-- in the header now.
--
-- Revision 1.1  2005/12/31 17:54:54  jsedwards
-- Extracted "create_class_definition" routine from "big_bang.c" and created
-- this file.
--
*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "crc32.h"
#include "objectify.h"
#include "objectify_private.h"


/*****************************************************************************/
/* This routine creates a class definition with the given name.              */
/*****************************************************************************/
#if 0
void nwos_create_class_definition(char* name_of_class)
{
    ObjRef class_ref;
    C_struct_Class_Definition class_def_obj;

    memset(&class_def_obj, 0, sizeof(class_def_obj));  /* zero it out */

    nwos_generate_new_id(&class_ref);

    printf("create_class_definition(%s) -> %02x%02x%02x%02x\n", name_of_class,
	   class_ref.id[0], class_ref.id[1], class_ref.id[2], class_ref.id[3]);
    
    nwos_fill_in_common_header(&class_def_obj.header.common, &class_ref, &nwos_class_definition_class_ref);

    nwos_create_reference_list(&class_ref, &class_def_obj.header.object.references);

    nwos_create_name(name_of_class, &class_def_obj.name);

    nwos_crc32_calculate((uint8*) &class_def_obj.header.object, sizeof(ObjectHeader), class_def_obj.header.common.header_chksum);
    nwos_crc32_calculate((uint8*) &class_def_obj.name, sizeof(class_def_obj) - sizeof(EveryObject), class_def_obj.header.common.data_chksum);

    nwos_write_object_to_disk(&class_ref, &class_def_obj, sizeof(class_def_obj));

    nwos_add_to_references(&class_ref, &nwos_class_definition_class_ref);
}
#endif

/*****************************************************************************/
/* This routine finds the class definition with the given name.              */
/*****************************************************************************/

bool nwos_find_class_definition(char* name, ObjRef* class_ref)
{
    C_struct_Class_Definition class_def_obj;
    ReferenceList* ref_list;
    int num_classes;
    ObjRef object_class;
    char buffer[128];
    int i;
    bool result = false;

    memset(class_ref, 0, sizeof(ObjRef));

    nwos_read_object_from_disk(&nwos_class_definition_class_ref, &class_def_obj, sizeof(class_def_obj));

    ref_list = nwos_malloc_reference_list(&class_def_obj.header.object.references);

    num_classes = ref_list->common_header.num_refs;

    /* printf("num_classes (in find_class_definition): %d\n", num_classes); */

    for (i = 0; i < num_classes; i++)
    {
	nwos_get_object_class(&ref_list->references[i], &object_class);   /* find out what kind of object it is */

	if (is_same_object(&object_class, &nwos_class_definition_class_ref))   /* it is a class definition object */
	{
	    nwos_read_object_from_disk(&ref_list->references[i], &class_def_obj, sizeof(class_def_obj));

	    nwos_name_to_string(&class_def_obj.name, buffer, sizeof(buffer));   /* get it's name */

	    if (strcasecmp(name, buffer) == 0)
	    {
		memcpy(class_ref, &ref_list->references[i], sizeof(ObjRef));
		result = true;
		break;
	    }
	}
    }

    nwos_free_reference_list(ref_list);
    ref_list = NULL;

    return result;
}


