/*
--             This file is part of the New World OS project
--                 Copyright (C) 2007-2008  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- This is a one time use program to add acronyms to the existing Credit Unions
--
-- $Log: add_acronyms.c,v $
-- Revision 1.4  2008/09/01 00:22:49  jsedwards
-- Fix year in copyright.  NO code changes.
--
-- Revision 1.3  2008/08/31 16:24:43  jsedwards
-- Added assert around call to nwos_read_object_from_disk because now it
-- returns false if it fails, before it asserted itself if it failed.
--
-- Revision 1.2  2007/07/01 19:44:12  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.1  2007/05/24 12:27:29  jsedwards
-- Initial version.
--
*/


#include <assert.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../crc32.h"
#include "../objectify_private.h"



int main(int argc, char* argv[])
{
    ObjRef root_ref;
    ObjRef acronym_ref;
    ObjRef cu_ref;
    C_struct_Credit_Union cu_obj;
    int i;

    struct name_acronym
    {
      char* name;
      char* acronym;
    };

    struct name_acronym credit_unions[] = {
      { "America First",    "AFCU" },
      { "Deseret First",    "DFCU" },
      { "Mountain America", "MACU" },
      { "Salt Lake City Credit Union", "SLCCU" },
      { "Trans West",       "TWCU" },
      { "Utah First",       "UFCU" },
    };
    const int num_credit_unions = (sizeof(credit_unions) / sizeof(struct name_acronym));


    nwos_log_arguments(argc, argv);

    nwos_initialize_objectify(NULL, 0, 0, DEFAULT_TYPE_RW, DEFAULT_FILE);

    nwos_set_encryption_level(Encryption_None);

    printf("Adding acronyms to credit unions on: %s\n", DEFAULT_FILE);

    root_ref.id[0] = 0;
    root_ref.id[1] = 0;
    root_ref.id[2] = 0;
    root_ref.id[3] = 1;

    nwos_set_root_object(&root_ref);

    for (i = 0; i < num_credit_unions; i++)
    {
	printf("%s: ", credit_unions[i].name);

	assert(nwos_find_public_credit_union(credit_unions[i].name, &cu_ref));

	assert(nwos_read_object_from_disk(&cu_ref, &cu_obj, sizeof(cu_obj)));

	nwos_create_public_acronym(credit_unions[i].acronym, &acronym_ref);

	assert(is_void_reference(&cu_obj.acronym));

	copy_reference(&cu_obj.acronym, &acronym_ref);

	nwos_add_to_references(&cu_ref, &cu_obj.acronym);

	nwos_crc32_calculate((uint8*) &cu_obj.full_name, sizeof(cu_obj) - sizeof(EveryObject), cu_obj.header.common.data_chksum);

	nwos_overwrite_object_to_disk(&cu_ref, &cu_obj, sizeof(cu_obj));

	printf("reference: %02x%02x%02x%02x\n", 
	       acronym_ref.id[0],
	       acronym_ref.id[1],
	       acronym_ref.id[2],
	       acronym_ref.id[3]);
    }

    nwos_terminate_objectify();

    return 0;
}

