<?php

function drawUserList()
{
    global $neConfig, $neDb, $neTheme, $neSession, $neModuleName;
    $tpl = $neTheme->getTemplate('user','user_list.tpl');
    $tpl->setVariable(array(
        'LABEL_USERNAME' => neTranslate('username'),
        'LABEL_POINTS' => neTranslate('points'),
        'LABEL_LAST_LOGIN' => neTranslate('last_login'),       
        'LABEL_FUNCTIONS' => neTranslate('functions')
    ));
    if ($neSession->isAdmin($neModuleName)) {
        $tpl->setVariable(array(
            'LABEL_UID' => neTranslate('uid'),
            'LABEL_IP' => neTranslate('ip'),
        ));    
    }
    //Get the Userdata from the Database:
    $strQuery  = 'SELECT * ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_users ';
    $strQuery .= 'ORDER BY user_name ASC ';
    $usersResult = $neDb->query($strQuery);
    neGetDbError($usersResult,__LINE__,__FILE__,$strQuery);

    //Show the Results:
    $tpl->setCurrentBlock('user');
    while ($user = $usersResult->fetchRow(DB_FETCHMODE_ASSOC)) {           
        $tpl->setVariable(array(
        'USER_NAME' =>  neFormatText($user['user_name'],'plain'),
        'USER_LAST_LOGIN' => neFormatTimestamp((int) $user['user_last_login'],'date-time'), 
        'USER_POINTS' => neFormatText($user['user_points'],'plain')
        ));
        if (!empty($user['email'])) {
            $tpl->setVariable('EMAIL_LINK',
            '<a href="mailto:'.$user['email'].'" >'
            .$neTheme->getImage('email',neTranslate('email'))
            .'</a>'
            );
        }	
        if ($neSession->isAdmin($neModuleName)) {
            $tpl->setVariable(array(
            'USER_ID' => (int) $user['user_id'],
            'USER_IP' => neFormatText($user['user_ip']),
            'EDIT_LINK' => '<a href="admin.php?mod=user&amp;op=edit_user&amp;user_id='
                           .$user['user_id'].'">'.$neTheme->getImage('edit',neTranslate('edit'))
                           .'</a>'
            ));
	}
            $tpl->parse('user');
    } //end while
    $usersResult->free();
    $tpl->show();
    $neTheme->drawSite(neTranslate('admin news',1));
}
?>
