<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* This module administrates and shows the Topics of a NukeEvent Site.
*
* @package nukeevent.modules.topics
* @author Christian Berg
* @version $Revision: 1.4 $
*/

neGetlang($neModuleName);
/**
* load the configuration for the topics module
*/ 
require_once('modules/topics/config.php');

/**
* load the functions needet my the topics module
*/
require_once('modules/topics/topics_functions.php');

if (isset($_POST['topic_id'])){
    $intTopicId = (int) $_POST['topic_id'];
} elseif (isset($_GET['topic_id'])) {
    $intTopicId = (int) $_GET['topic_id'];
}    
if (isset($_GET['linkid']) ) {
    $intLinkId  = (int) $_GET['linkid'];
}
if (isset($_POST['topic_name']) ) {
    $strName =  neCheckText($_POST['topic_name'],'nohtml');
}    
if (isset($_POST['topic_title'])){
    $strTitle = neCheckText($_POST['topic_title'],'nohtml');
}

if (isset($_POST['topic_description'])){
    $strDescription = (string)  neCheckText($_POST['topic_description'],'inline');
}
if (isset($_POST['link_name'])){
    $strLinkName = (string)  neCheckText($_POST['link_name'],'nohtml');
}
if (isset($_POST['link_url'])){
    $strLinkUrl = (string) neCheckText($_POST['link_url'],'nohtml');
}
if (isset($_POST['is_confirmed'])){
    $bolConfirmed = (boolean) $_GET['is_confirmed'];
}
if (MODULE_LOADER == 'admin.php' and empty($neOp)){
    $neOp = 'admin_topics';
}

if ( $neSession->IsAdmin($neModuleName) ) {
    switch ($neOp) {
      case 'add_link':
        require_once('modules/topics/topics_linkfunctions.php');
        addLink($intTopicId, $strLinkName, $strLinkUrl);
        die();
        break;

      case 'delete_link':
        require_once('modules/topics/topics_linkfunctions.php');
        deleteLink($intLinkId,$intTopicId);
        die();
        break;

      case 'edit_links':
        require_once('modules/topics/topics_linkfunctions.php');
        editTopicLinks($intTopicId);
        die();
        break;

      case 'add_topic':
        drawAddTopicForm($strName, $strTitle);
        die();
        break;

      case 'delete_topic':
        if ($bolConfirmed){
            deleteTopic($intTopicId);
        } else {
            drawDeleteAsk();
        }
        die();
        break;

      case 'edit_topic':
        editTopic($intTopicId);
        die();
        break;

      case 'post_add':
        addTopic($intTopicId, $strName, $strTitle, $strDescription);
		die();
        break;

      case 'post_edit':
        submitEdit($intTopicId, $strName, $strTitle, $strDescription);
        die();
        break;

      case 'admin_topics':
        drawTopicsAdmin();
        die();
        break;;
    }
}

switch ($neOp) {
  default:
    drawTopics();
    break;;
}
?>
