<?php

/**
*Draws a select box to choose if this article should be an top article or not.
*/
function getTopArticleSelect($isTopStory) {
    if ($isTopStory == 1) {
       $strOp  = '<option value="1" selected="selected">'.neTranslate('is_top_story').'</option>';
       $strOp .= '<option value="0">'.neTranslate('is_not_top_story').'</option>';
    } else {
       $strOp  = '<option value="1">'.neTranslate('is_top_story').'</option>';
       $strOp .= '<option value="0" selected="selected">'.neTranslate('is_not_top_story').'</option>';
    }
    return $strOp;
}


/**
* draws a selct box with all topics
*/
function getTopicSelect($intDefault) {
    global $neConfig,$neSession, $neDb;
    $strQuery  = 'SELECT topic_id, topic_title ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_topics ';
    $strQuery .= 'ORDER BY topic_title';
    $toplist = $neDb->query($strQuery);
    neGetDbError($toplist,__LINE__,__FILE__,$strQuery);
    $strReturn = '';
    while(list($intId, $strTitle) = $toplist->fetchRow() ) {
        if ( $intDefault == $intId ) {
            $strSelected = 'selected="selected"';
        } else {
            $strSelected = '';
        }
        $strReturn .= '<option value="'.$intId.'" '.$strSelected.'>';
        $strReturn .= $strTitle;
        $strReturn .= '</option>'."\n";
    }
    return $strReturn;
}

/**
* gets the small Images
*/
function getSmallImage($intArticleId,$strTopicName) {
    global $neTheme;
    $strImage = $neTheme->getImageSrc(
        $intArticleId.'_small',
        DATA_PATH.'news/'
    );
    if ($strImage) { 
        return $strImage;
    } else {
        return $neTheme->getImageSrc($strTopicName,DATA_PATH.'topics/');
    }
}

/**
* gets the big Images
*/
function getBigImage($intArticleId,$strTopicName) {
    global $neTheme;
    $strImage = $neTheme->getImageSrc(
        $intArticleId.'_big',
        DATA_PATH.'news/'
    );
    if ($strImage) { 
        return $strImage;
    } else {
        return false;
    }
}

function uploadSmallImage($intArticleId,$uploadedFile) {
	global $neConfig;
    $filename = DATA_PATH.'news/'.$intArticleId.'_small';
    switch ($uploadedFile['type']) {
	case 'image/jpeg' :
        $filename .= '.jpg';
        break;
    case 'image/gif' :
        $filename .= '.gif';
        break;
    case 'image/png' :
        $filename .= '.png';
        break;
    default :
		return false;
    }
    if (touch($filename)){
        @unlink(DATA_PATH.'news/'.$intArticleId.'_small.jpg');
        @unlink(DATA_PATH.'news/'.$intArticleId.'_small.png');
        @unlink(DATA_PATH.'news/'.$intArticleId.'_small.gif');
	    neResizeImage(
	        $uploadedFile['tmp_name'],
	        $filename,
	        $neConfig['news']['smallimage_width'],
	        $neConfig['news']['smallimage_height']
	    );
    }
}

function uploadBigImage($intArticleId,$uploadedFile)
{
	global $neConfig;
    $filename = DATA_PATH.'news/'.$intArticleId.'_big';
    switch ($uploadedFile['type']) {
	case 'image/jpeg' :
        $filename .= '.jpg';
        break;
    case 'image/gif' :
        $filename .= '.gif';
        break;
    case 'image/png' :
        $filename .= '.png';
        break;
    default :
		return false;
    }
	if (touch($filename)) {
        @unlink(DATA_PATH.'news/'.$intArticleId.'_big.jpg');
        @unlink(DATA_PATH.'news/'.$intArticleId.'_big.png');
        @unlink(DATA_PATH.'news/'.$intArticleId.'_big.gif');
	    neResizeImage(
	        $uploadedFile['tmp_name'],
	        $filename,
	        $neConfig['news']['bigimage_width'],
	        $neConfig['news']['bigimage_height']
	    );
    }
}
?>
