<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* The Admin Module to administrate Modules.
* Sounds like a Snake that bites in her Tail, he?
*
* @package nukeevent.modules.module-admin
* @author $Author: xeniac $
* @version $Revision: 1.4 $
*/

/**
 * include the configuration fpr the Module Admin.
 * @see config.php
 */
 require_once('modules/module-admin/config.inc.php');
 
/**
* include the funcions file for the module-admin.
* @see modules_functions.php
*/
require_once('modules/module-admin/modules_functions.php');
neGetLang('module-admin');

// here we have to add the images
define('IMAGE_DIR', DATA_PATH.'modules/');

if (isset($_GET['id'])) {
    $intModuleId = (int) $_GET['id'];
}

if (isset($_GET['mod_name'])) {
    $strModuleName= neCheckText($_GET['mod_name'],'plain');
}

if ( $neSession->IsAdmin($neModuleName) ){
    switch ($neOp) {
     case "activate_module":
         activateModule($intModuleId);
         break;

     case 'change_modules_perm':
         changeModulesPermission($_GET['view']);
         break;

     case "deactivate_module":
         deactivateModule($intModuleId);
         break;

     case "edit_module":
         editModule($intModuleId);
         break;

       case "show_readme":
         showReadme($strModuleName);
         break;
       case 'install':
           showInstallModuleForm();
           break;
       case 'install_module':
           require_once('modules/'.$strModuleName.'/'.$strModuleName.'_setup.php');
           break;
       case 'uninstall_module':
           require_once('modules/'.$strModuleName.'/'.$strModuleName.'_setup.php');
           break;
       case "admin_modules":
       default:
        adminModules();
        break;   }
} else {
    $neTheme->drawErrorpage(
        neTranslate("only_admin"),
        neTranslate("message-only_admin")
    );
}
?>