<?php
/*==NukeEvent Portal System====================================================
Copyright 2002 by Christian Berg

Code based on PHP-NUKE Web Portal System Copyright (c) 2002 by
Francisco Burzi (fbc@mandrakesoft.com) http://phpnuke.org

This program is free software. You can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 or any higher Version
of the License.
=============================================================================*/

/**
* The Functions File for the Jirca Module:
*
* @package nukeevent.modules.jirca
* @author $Author: xeniac $
* @version $Revision: 1.3 $
*/

/**
* draws the optionfields for the block permissions.
* Possible options are all users,registed users and only admins.
* @param integer default the permission that sould be the default value.
*/
function getAlbumVisibleOptions($default){
    $return = '';
    $default == BLOCK_ONLYADMIN ? $selected='selected="selected"' : $selected='';
    $return .= '<option value="'.BLOCK_ONLYADMIN.'" '.$selected.'>';
    $return .= neTranslate('only_admins');
    $return .= '</option>';

    $default == BLOCK_ONLYREGISTED ? $selected='selected="selected"' : $selected='';
    $return .= '<option value="'.BLOCK_ONLYREGISTED.'" '.$selected.'>';
    $return .= neTranslate('only_registed_users');
    $return .= '</option>';

    $default == BLOCK_ALLUSERS ? $selected='selected="selected"' : $selected='';
    $return .= '<option value="'.BLOCK_ALLUSERS.'" '.$selected.'>';
    $return .= neTranslate('all_users');
    $return .= '</option>';
    return $return;
}


function displayAddAlbumForm()
{
    global $neConfig, $neDb, $neTheme, $neSession,$neModuleName;
    $neTheme->drawTitle(neTranslate('add_album'));
    $tpl = $neTheme->getTemplate('gallery','add_album.tpl');
    $tpl->setVariable(array(
    'MODULE_LOADER' => MODULE_LOADER,
    'MODULE' => $neModuleName,
    'OP' => 'submit_add_album',
    'MESSAGE_ADD_ALBUM' => neTranslate('text-add_album'),
    'LABEL_ADD_ALBUM' => neTranslate('add_album'),
    'LABEL_ALBUMTITLE' => neTranslate('album_title'),
    'LABEL_ALBUMNAME' => neTranslate('album_name')
    ));
    $tpl->show();
    $neTheme->drawSite(neTranslate('add_album'));
}

function showAddUploadedForm()
{
    global $neConfig, $neDb, $neTheme, $neSession,$neModuleName;
    $tpl = $neTheme->getTemplate('gallery','commit_upload.tpl');
    $tpl->setVariable(array(
    'ACTION' => MODULE_LOADER,
    'MODULE' => 'gallery',
    'OP' => 'submit_add_uploaded',
    'LABEL_ALBUM' => neTranslate('album'),
    'ALBUM' => getAlbumSelect($strAlbumName),
    'LABEL_ADD_UPLOADED' => neTranslate('add_uploaded'),
    'TEXT_ADD_UPLOADED' => neTranslate('text-add_album'),
    'LABEL_ALBUMTITLE' => neTranslate('album_title'),
    'LABEL_ALBUMNAME' => neTranslate('album_name'),
    'LABEL_FILE_NAME' => neTranslate('file_name'),
    'LABEL_FILE_SIZE' => neTranslate('file_size'),
    'LABEL_IMAGE_SIZE' => neTranslate('image_size')
    ));
    $uploadDir = dir(UPLOAD_DIR);
    while( $file = $uploadDir->read() ) {
        $imageSize = getimagesize(UPLOAD_DIR.$file);
        if ($imageSize == false) {
            continue;
        }
        $tpl->setVariable(array(
        'FILE_NAME' => $file,
        'IMAGE_SIZE' => $imageSize[0].'x'.$imageSize[1],
        'FILE_SIZE' => round(filesize(UPLOAD_DIR.$file)/1024).' kB'
        ));
        $tpl->parse('file');
    }
    
    $tpl->show();
    $neTheme->drawSite(neTranslate('add_album'));
}

function addAlbum($strAlbumName,$strAlbumTitle) {
    global $neConfig, $neDb, $neTheme, $neSession,$neModuleName;
    if (empty($strAlbumName)) {
        $neTheme->drawErrorpage(
            neTranslate('empty_albume_name'),
            neTranslate('text-empty_albume_name')
        );
    }
    if (empty($strAlbumTitle)) {
        $neTheme->drawErrorpage(
            neTranslate('empty_albume_title'),
            neTranslate('text-empty_albume_title')
        );
    }
    $strQuery  = 'SELECT album_name FROM '.$neConfig['db']['prefix'].'_gallery_albums ';
    $strQuery .= 'WHERE album_name = '.$neDb->quote($strAlbumName);
    $result = $neDb->getOne($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    if ($result == $strAlbumName) {
        $neTheme->drawErrorpage(
            neTranslate('album_exists'),
            neTranslate('text-album_exists')
        );
    }

    $strQuery  = 'INSERT INTO '.$neConfig['db']['prefix'].'_gallery_albums ';
    $strQuery .= '(album_name,album_title) ';
	 $strQuery .= 'VALUES('.$neDb->quote($strAlbumName).','.$neDb->quote($strAlbumTitle).')';
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    neRedirect(MODULE_LOADER."?mod=$neModuleName&op=edit_album&name=$strAlbumName");
}

function displayEditAlbumForm($strAlbumName)
{
    global $neConfig, $neDb, $neTheme, $neSession,$neModuleName;
    $strQuery  = 'SELECT * FROM '.$neConfig['db']['prefix'].'_gallery_albums ';
    $strQuery .= 'WHERE album_name='.$neDb->quote($strAlbumName);
    $album = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
    neGetDbError($album,__LINE__,__FILE__,$strQuery);
    
    $neTheme->drawTitle(neTranslate('edit_album'));
    $tpl = $neTheme->getTemplate('gallery','edit_album.tpl');
    $tpl->setVariable(array(
    'MODULE_LOADER' => MODULE_LOADER,
    'MODULE' => $neModuleName,
    'OP' => 'submit_edit_album',
    'MESSAGE_ADD_ALBUM' => neTranslate('text-add_album'),
    'LABEL_EDIT_ALBUM' => neTranslate('edit_album'),
    'LABEL_ALBUMTITLE' => neTranslate('album_title'),
    'LABEL_ALBUMNAME' => neTranslate('album_name'),
    'LABEL_ALBUMDESCRIPTION' => neTranslate('album_description'),
    'LABEL_ALBUMVISIBLE' => neTranslate('album_visible'),
    'LABEL_ALBUMIMAGE' => neTranslate('album_image'),
    'ALBUM_NAME' => $album['album_name'],
    'ALBUM_TITLE' => $album['album_title'],
    'ALBUM_DESCRIPTION' => $album['album_description'],
    'ALBUM_IMAGE' => $neTheme->getImageSrc($album['album_name'],DATA_PATH.'gallery/albums/'),
    'ALBUM_VISIBLE' => getAlbumVisibleOptions($album['album_visible'])
    ));
    $tpl->show();
    $neTheme->drawSite(neTranslate('add_album'));
}

function displayEditImageForm($intImageId)
{
    global $neConfig, $neDb, $neTheme, $neSession, $neModuleName;
    $tpl = $neTheme->getTemplate('gallery','edit_image.tpl');

    //image
    $strQuery = 'SELECT * FROM '.$neConfig['db']['prefix'].'_gallery_images ';
    $strQuery .= "WHERE image_id='$intImageId'"; 
    $image = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
    neGetDbError($image,__LINE__,__FILE__,$strQuery);
    $tpl->setVariable(array(
        'LABEL_EDIT_IMAGE' => neTranslate('edit_image'),
        'LABEL_IMAGE_ALBUM' => neTranslate('image_album'),
        'LABEL_IMAGE_DESCRIPTION' => neTranslate('image_description'),
        'IMAGE_MEDIUM' => getMediumImage($image['image_id']),
        'IMAGE_ORIGINAL' => $neTheme->getImageSrc($image['image_id'],DATA_PATH.'gallery/images/'),
        'IMAGE_DESCRIPTION' => neCheckText($image['image_descr'],'plain'),
     ));
    $tpl->show();
    $neTheme->drawSite();
}

function editAlbum($strAlbumName,$strAlbumTitle,$strAlbumDescription,$intAlbumVisible) {
    global $neConfig, $neDb, $neTheme, $neSession,$neModuleName;
    if ( is_uploaded_file($_FILES['album_image']['tmp_name']) ) {
        uploadAlbumImage($strAlbumName);
    }
    $strQuery  = 'UPDATE '.$neConfig['db']['prefix'].'_gallery_albums ';
    $strQuery .= 'SET ';
    $strQuery .= 'album_title = '.$neDb->quote($strAlbumTitle).', ';
    $strQuery .= 'album_description = '.$neDb->quote($strAlbumDescription).', ';
    $strQuery .= 'album_visible = '.$neDb->quote($intAlbumVisible);
    $strQuery .= ' WHERE album_name = '.$neDb->quote($strAlbumName);
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    neRedirect(MODULE_LOADER."?mod=$neModuleName");    
}

function uploadAlbumImage($strAlbumName) {
    global $neConfig;
    if (is_uploaded_file($_FILES['album_image']['tmp_name'])) {
        $dirname = DATA_PATH.'gallery/albums/';
        $filename = $strAlbumName;
        switch($_FILES['album_image']['type']) {
		      case 'image/jpeg':
            $filename .= ".jpg";
			   break;	
		      case 'image/gif':
		      $filename .= ".gif";
			   break;	
		      case 'image/png':
		      $filename .= ".png";
			   break;		   
		      default:
		      echo 'not_an_image:'.$_FILES['album_image']['type'];
            return false;
            break;
	     }
        @unlink($dirname.$strAlbumName.'.jpg');
        @unlink($dirname.$strAlbumName.'.png');
        @unlink($dirname.$strAlbumName.'.gif');
        neResizeImage(
            $_FILES['album_image']['tmp_name'],
            $dirname.$filename,
            $neConfig['gallery']['albumimage_width'],
            $neConfig['gallery']['albumimage_height']
	     );
	     return true;
    } else {
        return false;
    }
}

function getAlbumSelect($strDefault) {
    global $neConfig,$neSession, $neDb;
    $strQuery  = 'SELECT album_name, album_title ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_gallery_albums ';
    $strQuery .= 'ORDER BY album_title';
    $toplist = $neDb->query($strQuery);
    neGetDbError($toplist,__LINE__,__FILE__,$strQuery);
    $strReturn = '';
    while($album = $toplist->fetchRow(DB_FETCHMODE_ASSOC) ) {
        if ( $album['album_name'] == $strDefault) {
            $strSelected = 'selected="selected"';
        } else {
            $strSelected = '';
        }
        $strReturn .= '<option value="'.$album['album_name'].'">'.$album['album_title'];
        $strReturn .= $strTitle;
        $strReturn .= '</option>'."\n";
    }
    return $strReturn;
}

function drawUploadForm($strAlbumName) {
   global $neTheme,$neModuleName;
   $neTheme->drawTitle(neTranslate('add_images'));
   $tpl = $neTheme->getTemplate($neModuleName,'add_images.tpl');
   $tpl->setVariable(array(
       'ACTION' => MODULE_LOADER,
       'MODULE' => 'gallery',
       'OP' => 'submit_upload',
       'LABEL_UPLOAD_IMAGES' => neTranslate('upload_images'),
       'LABEL_ALBUM' => neTranslate('album'),
       'ALBUM' => getAlbumSelect($strAlbumName)
   ));
	$tpl->setCurrentBlock('image');
   for ($i=1;$i<=10;$i++) {
       $tpl->setVariable(array(
           'LABEL_LOCAL_IMAGE' => neTranslate('local_image'),
           'IMAGE_NAME' => $i
       ));
       $tpl->parse('image');
   }
   $tpl->show();
   $neTheme->drawSite(neTranslate('import_files'));
}


function addImage($imageFile,$imageAlbum) {
    global $neSession,$neDb,$neConfig;
    $strQuery  = "SELECT image_id FROM ".$neConfig['db']['prefix'].'_gallery_images';
    $strQuery .= ' ORDER BY image_id DESC LIMIT 1';
    $imageId = $neDb->getOne($strQuery);
    neGetDbError($imageId,__LINE__,__FILE__,$strQuery);
    ++$imageId;
    $size=getimagesize($imageFile);
    if ($size == false) {
	    return false;
    }
    $imageType=$size[2];
    unset($size);
    switch ($imageType) {
        case 1:
        $outputFile = "$imageId.gif";
        break;
        case 2:
        $outputFile = "$imageId.jpg";
        break;
        case 3:
        $outputFile = "$imageId.png";
        break;
        default:
        trigger_error("addImage: $imageFile is not an Image");
        return false;
    }
    if (!rename($imageFile, DATA_PATH.'gallery/images/'.$outputFile)) {
        print ("failed to copy $imageFile...<br>\n");
        return false;
    }
    if ($neSession->isAdmin()) {
        $imageApproved = 1;
    } else {
        $imageApproved = 0;
    }
    $imageDescr = '';
    $strQuery = 'INSERT INTO '.$neConfig['db']['prefix'].'_gallery_images ';
    $strQuery .= '(image_id,image_album,image_approved,image_descr) ';
    $strQuery .= 'VALUES(';
    $strQuery .= " '$imageId',";
    $strQuery .= " '$imageAlbum',";
    $strQuery .= " '$imageApproved',";
    $strQuery .= " '$imageDescr'";
    $strQuery .= ")";
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    return true;
}

function extractZip($zipFile,$imageAlbum) {
    global $neSession,$neDb,$neConfig;
    echo '<pre>';
    system("unzip $zipFile -d ".getcwd().'/'.DATA_PATH.'gallery/upload/');
    echo '</pre>';
    $uploadDir = dir(DATA_PATH.'gallery/upload');
    echo "Handle: " . $uploadDir->handle . "<br />\n";
    echo "Path: " . $uploadDir->path . "<br />\n";
    while (false !== ($entry = $uploadDir->read())) {
        addImage(DATA_PATH.'gallery/upload/'.$entry,$imageAlbum);
    }
    $uploadDir->close();
}
function uploadImages($strAlbumName) {
    global $neConfig,$neTheme;
    echo '<table class="tableview"><tr class="tableview">';
    echo '<th class="tableview">'.neTranslate('image_name').'</th>';
    echo '<th class="tableview">'.neTranslate('image_type').'</th>';
    echo '<th class="tableview">'.neTranslate('action').'</th>';
    echo '</tr>';
    $neTheme->drawTitle(neTranslate('upload_images'));
    foreach($_FILES as $inputFile) {
        if ( !is_uploaded_file($inputFile['tmp_name'])) {
            continue;
        }
        echo '<tr class="tableview">';
        echo '<td class="tableview">'.$inputFile['name'].'</td>';
        echo '<td class="tableview">'.$inputFile['type'].'</td>';
        switch($inputFile['type']) {
		      case 'image/jpeg':
		      case 'image/gif':
		      case 'image/png':
              if (addImage($inputFile['tmp_name'],$strAlbumName)) {
                  echo '<td class="tableview">'.neTranslate('succsess').'</td>';
              } else {
                  echo '<td class="tableview">'.neTranslate('failure').'</td>';
              }	   
			  break;	
              case 'application/zip':
              extractZip($inputFile['tmp_name'],$strAlbumName);
              default:
              continue;
              break;
	    }
	    echo '</tr>';
   }
   echo '<tr class="tableview">';
   echo '<td class="formbuttons" colspan="3">';
   echo '<button type="button" onclick="location.href=\''.MODULE_LOADER.'?mod=gallery&amp;op=add_images&amp;name='.$strAlbumName.'\'">'.neTranslate('add_images').'</button>';
   echo '<button type="button" onclick="location.href=\''.MODULE_LOADER.'?mod=gallery&amp;op=show_album&amp;name='.$strAlbumName.'\'">'.neTranslate('show_album').'</button>';
   
   echo '</td>';
   echo '</table>';
   $neTheme->drawSite();
   return true;
}

function addUploadedImages($strAlbumName,$filesToAdd) {
    global $neConfig,$neTheme;
    foreach($filesToAdd as $inputFile) {
        $inputFile = UPLOAD_DIR.$inputFile;
        if ( !is_file($inputFile)) {
            continue;
        }
        echo "processing $inputFile<br/>";
        addImage($inputFile,$strAlbumName);
   }
   $neTheme->drawSite();
   return true;
}

?>