<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* The Setuproutine for the FAQ Module:
*
* @package nukeevent.modules.faq
* @author $Author: xeniac $
* @version $Revision: 1.1 $
*/

/**
* Installs the FAQ Module
*/
function install()
{
    global $neDb, $neConfig;
    addModule('faq','FAQ');
    addAdminmenu('faq','list_faq','List FAQ');
    addAdminmenu('faq','add_faq','Add FAQ');

    $strQuery  = 'CREATE TABLE IF NOT EXISTS '.$neConfig['db']['prefix'].'_faq_faqs (';
    $strQuery .= ')';
    $result = $neDb->query($strQuery);
    negetDbError($result,__LINE__,__FILE__,$strQuery);

    $strQuery = 'CREATE TABLE IF NOT EXISTS '.$neConfig['db']['prefix'].'_faq_questions (
    ) ';
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
}

/**
* uninstalls the FAQ module
*/
function uninstall()
{
    global $neDb, $neConfig;
    removeModule('faq');
    removeAdminmenu('faq');
    $strQuery  = 'DROP TABLE '.$neConfig['db']['prefix'].'_faq_faqs';
    $result = $neDb->query($strQuery);
    negetDbError($result,__LINE__,__FILE__,$strQuery); 
    $strQuery  = 'DROP TABLE '.$neConfig['db']['prefix'].'_faq_questions';
    $result = $neDb->query($strQuery);
    negetDbError($result,__LINE__,__FILE__,$strQuery); 
}

switch ($neOp){
    case 'install_module':
        install();
        $neTheme->drawSite();
        break;
    case 'uninstall_module':
        uninstall();
        $neTheme->drawSite();
        break;
}
?>
