<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Foobar; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* This is the Events Module for NukeEvent.
* @package nukeevent.modules.events
* @author $Author: xeniac $
* @version $Revision: 1.2 $
*/

neGetlang($neModuleName);

/**
* load the configuration for the News Module.
*/
require_once ('modules/events/config.php');

/**
* load the common Functions for the News Module.
*/
require_once ('modules/events/events_functions.php');

if (isset($_POST['event_id'])) {
    $intId= (int) $_POST['event_id'];
} elseif (isset($_GET['id'])) {
    $intId= (int) $_GET['id'];
} else {
    $intId = null;
}

if (isset($_GET['topic'])) {
    $intTopic= (int) $_GET['topic'];
} else {
    $intTopic = null;
}

if (isset($_POST['view'])) {
    $strView = neCheckText($_POST['view']);
} elseif (isset($_GET['view'])) {
    $strView = neCheckText($_GET['view']);
} else {
    $strView = $neConfig['events']['default_view'];
}

if (isset($_GET['is_confirmed']) AND $_GET['is_confirmed'] == 1) {
    $bolConfirmed = true;
} else {
    $bolConfirmed = false;
}

if (MODULE_LOADER == 'admin.php' and empty($neOp)) {
    $neOp= 'admin_events';
}

if ($neSession->isAdmin($neModuleName)) {
    switch($neOp) {
    case 'admin_events':
        include_once('modules/events/admin_functions.php');
        adminEvents();
    case 'delete_event' :
        include_once ('modules/events/admin_functions.php');
        deleteEvent($intId,$bolConfirmed);
        break;
    case 'add_link' :
        include_once ('modules/events/links_admin.php');
        addLink($intId, $_POST['link_name'], $_POST['link_url']);
        break;
    case 'delete_link' :
        include_once ('modules/events/links_admin.php');
        deleteLink($intId, $_GET['article']);
        break;
    case 'edit_links' :
        include_once ('modules/events/links_admin.php');
        editLinks($intId);
        break;
    }    
}
if (   ($neSession->isAdmin($neModuleName)) 
    or ($neSession->isLoggedIn() AND $neConfig['events']['allow_user_post'])
    or ($neConfig['events']['allow_anonymous_post']))
    {
    switch($neOp) {
    case 'edit_event':
        include('admin_functions.php');
        showEditEventForm($intId);
        break;
    case 'submit_edit_event':
        include('admin_functions.php');
        EditEvent($_POST);
        break;
    case 'new_event':
        include('admin_functions.php');
        showAddEventForm();
        break;
    case 'submit_new_event':
        include('admin_functions.php');
        addEvent($_POST);
        die();
        break;
    }
}
switch ($neOp) {
    case 'show_event' :
        include('modules/events/event_details.php');
        showEvent($intId);
        break;
    default :
        if (file_exists('modules/events/view_'.$strView.'.php')) {
            include ('modules/events/view_'.$strView.'.php');
        } else {
            include ('modules/events/view_'.$neConfig['events']['default_view'].'.php');
        }
        displayView($intTopic);
        break;
}
?>