<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* shows a detailed view of the event.
*
* @package nukeevent.modules.events
* @author $Author: xeniac $
* @version $Revision: 1.3 $
*/

/**
 * Display the Article Text
 */
function showEvent($intId){
    global $neModuleName, $neTheme ,$neConfig, $neDb, $neSession;
    $strQuery  = 'SELECT event.*, topic_name,topic_title,topic_id, user_name ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_events as event, ';
    $strQuery .= $neConfig['db']['prefix'].'_users, ';
    $strQuery .= $neConfig['db']['prefix'].'_topics ';
    $strQuery .= "WHERE event_id='$intId' ";
    $strQuery .= 'AND topic_id=event_topic ';
    $strQuery .= 'AND user_id=event_author ';
    $event = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
    neGetDbError($event,__LINE__,__FILE__,$strQuery);
    $tpl = $neTheme->getTemplate('events','event_details.tpl');
    /* set the article data */
    $eventStart = strtotime($event['event_start']);
    $eventEnd = strtotime($event['event_end']);
    
    $tpl->setVariable( array(
    'LABEL_EVENT_START' => neTranslate('event_start'),
    'LABEL_EVENT_END' => neTranslate('event_end'),
    'LABEL_DATE' => neTranslate('date'),
    'LABEL_LOCATION' => neTranslate('location'),
    'EVENT_ID'  => (int) $event['event_id'],
    'EVENT_AUTHOR'      => neFormatText($event['user_name'],'plain'),
    'EVENT_CREATED'     => neFormatTimestamp($event['event_created'],'date'),
    'EVENT_TITLE'       => neFormatText($event['event_title'],'plain'),
    'EVENT_START_TIME'  => neFormatTimestamp($eventStart,'time'),
    'EVENT_START_DATE'  => neFormatTimestamp($eventStart,'date'),
    'EVENT_END_TIME'    => neFormatTimestamp($eventEnd,'time'),
    'EVENT_END_DATE'    => neFormatTimestamp($eventEnd,'date'),
    'EVENT_LOCATION'    => neFormatText($event['event_location'],'plain'),
    'EVENT_ABSTRACT'    => neFormatText($event['event_summary'],'plain'),
    'EVENT_DETAIL'      => neFormatText($event['event_detail'],'html'),
    'TOPIC_ID'    => (int) $event['topic_id'],
    'TOPIC_NAME'  => neFormatText($event['topic_name'],'plain'),
    'TOPIC_TITLE' => neFormatText($event['topic_title'],'plain'),
    'TOPIC_IMAGE'  => $neTheme->GetImageSrc($event['topic_name'],DATA_PATH.'topics/'),
    'SMALL_IMAGE' => getSmallImage($event['event_id'],$event['topic_name']),
    'BIG_IMAGE'   => getBigImage($event['event_id'],$event['topic_name'])
    ));

   
    // Parse Event related Links  
    $strQuery  = 'SELECT link_title, link_url ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_events_links ';
    $strQuery .= "WHERE event_id = '$event[event_id]' ";
    $eventLinks = $neDb->query($strQuery);
    negetDbError($eventLinks,__LINE__,__FILE__,$strQuery);
    if ( $eventLinks->numRows() > 0) {    
        $tpl->setVariable( 'LABEL_RELATED_LINKS',neTranslate('related_links'));
        $tpl->setCurrentBlock('event_link');
        while ($eventLinks->fetchInto($link,DB_FETCHMODE_ASSOC) ){
            $tpl->setVariable('LINK_URL',$link['link_url']);
            $tpl->setVariable('LINK_NAME',$link['link_title']);
            $tpl->parse('event_link');
        }
    }

    /* Parse Topiclinks */  
    $strQuery  = 'SELECT link_title, link_url ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_topics_links ';
    $strQuery .= "WHERE topic_id = '$event[topic_id]' ";
    $topiclinks = $neDb->query($strQuery);
    negetDbError($topiclinks,__LINE__,__FILE__,$strQuery);
    if ( $topiclinks->numRows() > 0) {    
        $tpl->setVariable( 'LABEL_RELATED_LINKS',neTranslate('related_links'));
        $tpl->setCurrentBlock('topic_link');
        while ($topiclinks->fetchInto($link,DB_FETCHMODE_ASSOC) ){
            $tpl->setVariable('LINK_URL',$link['link_url']);
            $tpl->setVariable('LINK_NAME',$link['link_title']);
            $tpl->parse('topic_link');
        }
    }

    //show comments if activated
    if ($neConfig['events']['allow_user_comments']) {
        include_once('modules/comments/comments_functions.php');
        $tpl->setVariable('COMMENTS',showComments(
            $neConfig['db']['prefix'].'_events_comments',
            $event['event_id'],
            MODULE_LOADER.'?mod=events&op=show_event&id='.$event['event_id']
         ));
    }
    
    /* Show the Admin Functions. */ 
    if ($neSession->isAdmin('news')) {
        $tpl->setVariable(array(
		  'DELETE_LINK' => getDeleteLink($event['event_id'],$event['event_title']),
		  'EDIT_LINK' => '<a href="'.MODULE_LOADER.'?mod=events&amp;op=edit_event&amp;id='.$event['event_id'].'">'.
                      $neTheme->getImage('edit',neTranslate('edit')).'</a> ',
		  'EDIT_LINKS_LINK' => '<a href="'.MODULE_LOADER.'?mod=events&amp;op=edit_links&amp;id='.$event['event_id'].'">'.$neTheme->getImage('link',neTranslate('edit_links')).'</a> '
        ));
    }   
    $tpl->show();
    $neTheme->drawSite(neFormatText($event['event_title']));
}
?>
