<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* Functions to import content into the content manager.
*
* @package nukeevent.modules.content
* @author $Author: xeniac $
* @version $Revision: 1.4 $
*/

function drawImportForm() {
    global $neTheme;
   $neTheme->drawTitle(neTranslate('import_files'));
    ?>
    <p class="advice"><?php echo neTranslate('message-import_form');?></p>

    <form method="post" action="<?php echo MODULE_LOADER ?>" enctype="multipart/form-data">
    <input type="hidden" name="mod" value="content" />
    <input type="hidden" name="op" value="submit_import" />
    <table class="formtable" align="center">
    <tr class="formtable">
     <td colspan="2" class="formheader">
      <?php echo neTranslate('import_files');?>
     </td>
    </tr>
    <?php for($i = 0 ;$i <= 10;$i++) { ?>
    <tr class="formtable">
     <td class="formdescr">
      <?php echo neTranslate('local_file');?>
     </td>
     <td class="formelement">
      <input type="file" class="file" name="importfile<?php echo $i?>">
     </td>
    </tr>
    <?php } ?>
     <tr>    
     <td class="formbuttons" colspan="2">
      <input type="submit" class="submit" value="<?php echo neTranslate('start_import');?>" />
     </td>
    </tr>
   </table>
   </form>
   <?php
   $neTheme->drawSite(neTranslate('import_files'));
}

function importPage($file)
{
    $strName = basename($file['name'],'.html');  
    if (empty($strName)) {
    	trigger_error('importPage: no',USER_ERROR);
    }
    //load the file into a string
    $fileContent = implode(file($file['tmp_name'])," ");
        
    //fetch the title
    preg_match('/<title .*>(.*?)<\/title>/',$fileContent,$arrTmp);
    $strTitle = $arrTmp[1];
    
    //fetch the content
    preg_match("/<body.*?>([^\\[]*)<\/body>/",$fileContent,$arrTmp);
    $strContent = $arrTmp[1];
    unset($arrTmp,$fileContent);  

    if ( !empty($strName) AND !empty($strContent)) { 
        submitPage($strName,$strTitle,$strContent);
        return true; 
    } else {
        return false;
    }
}

function uploadImage($file)
{
    global $neConfig;
    $file['name'] = strtolower($file['name']);
    if ( !is_dir(IMAGE_DIR) ) {
        if ( !mkdir(IMAGE_DIR) ) {
            echo IMAGE_DIR.' does not exist and connot created';
            return false;
        }
    }
    $uploadfile = IMAGE_DIR.'/'.$file['name'];    
    if (move_uploaded_file($file['tmp_name'], $uploadfile)) {
        return true;	
	   } else {
        return false;
    }
}

function importFiles($arrFiles) 
{
    global $neConfig, $neDb, $neTheme, $neModuleName;
    foreach($arrFiles as $file) {
        if ( empty($file['name']) ) {
            continue;
        }
        echo neTranslate('processing').' '.$file['name'].' ' ;
        if ( ereg('text/',$file['type']) ) {
            $succsess = importPage($file);
        } elseif ( ereg('image/',$file['type']) ) {
            $succsess = uploadImage($file);        
        }
        if ( $succsess ) {
            echo '<span style="color:green">'.neTranslate('ok').'</span>';
        } else {
            echo '<span style="color:red">'.neTranslate('error').'</span>';
        }
        echo "<br />\n";
    }    
    echo '<p><a href="'.MODULE_LOADER.'?mod=content">';
    echo neTranslate('back_to_admin');
    echo '</a></p>';
    $neTheme->drawSite();
}
?>
