<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* Administrative Functions for the Content Manager
*
* @package nukeevent.modules.content
* @author $Author: xeniac $
* @version $Revision: 1.6 $
*/

/**
* Show the Administrative Content Interface.
*/
function adminContent()
{
    global $neConfig, $neDb, $neTheme, $neModuleName;
    $strTopicsTable = '';
    $count = 0;
    $strQuery  = 'SELECT page_name, author, title, active, changed ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_content ';
    $strQuery .= 'ORDER BY page_name';
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    $neTheme->drawTitle(neTranslate('content_admin'));
	$tpl = $neTheme->getTemplate($neModuleName,'admin_content.tpl');
	$tpl->setVariable(array(
       'LABEL_NAME'   => neTranslate('name'),
       'LABEL_TITLE'  => neTranslate('title'),
       'LABEL_AUTHOR' => neTranslate('author'),
       'LABEL_ACTIVE' => neTranslate('active'),
       'LABEL_CHANGED' => neTranslate('changed'),
       'LABEL_FUNCTIONS' => neTranslate('functions'),
       'LABEL_ADDPAGE' => neTranslate('add_page'),
       'LABEL_IMPORT' => neTranslate('import_files'),
       'LINK_ADDPAGE' => MODULE_LOADER.'?mod=content&amp;op=add',
       'LINK_IMPORT' => MODULE_LOADER.'?mod=content&amp;op=import',
	));

    while($page = $result->fetchRow(DB_FETCHMODE_ASSOC)) {
        $tpl->setCurrentBlock('page');
        $tpl->setVariable(array(
        'NAME' => neFormatText($page['page_name']),
        'PREVIEW_LINK' => MODULE_LOADER.'?mod=content&amp;op=show&amp;name='.$page['page_name'],
        'TITLE' => neFormatText($page['title']),
        'AUTHOR' => neGetUserName($page['author']),		
        'CHANGED' => $page['changed'],	
        'ACTIVE' =>getActiveLink($page['page_name'], $page['active']),
        'EXPORT' => getExportLink($page['page_name']),
        'DELETE' => getDeleteLink($page['page_name']),
        'EDIT' => getEditLink($page['page_name']),
        ));
        $tpl->parse('page');
    }
    $tpl->show();
    $neTheme->DrawSite(neTranslate('content'));
}
//==Admin Functions============================================================

/**
* Submits changes to a Page in the Database, or add the Page if it does not exist.
*/
function submitPage($strName, $strTitle, $strContent,$strGroup)
{
    global $neConfig, $neDb, $neDbWrite, $neSession;
    $strName    = $neDb->quote($strName);
    $strTitle   = $neDb->quote($strTitle);
    $strContent = $neDb->quote($strContent);
    $strAuthor  = $neDb->quote( (int) $neSession->getId());
    $strGroup  = $neDb->quote($strGroup);
    
    // Look if the Page exist
    $strQuery  = 'SELECT * FROM '.$neConfig['db']['prefix'].'_content ';
    $strQuery .= "WHERE page_name=$strName";
    $result = $neDb->query($strQuery);
    neGetDbError($result, __FILE__, __LINE__,$strQuery);

    //Do we edit a Page, or do we have to add a new?
    if ( $result->numRows() > 0 ) {
    	$original = $result->fetchRow(DB_FETCHMODE_ASSOC);
    	//Save a copy in the history
        $strQuery  = 'INSERT INTO '.$neConfig['db']['prefix'].'_content_archive';
        $strQuery .= '(page_name, title, content_group, content, author, changed) ';
        $strQuery .= 'VALUES(';
        $strQuery .= $neDb->quote(neCheckText($original['page_name'])).', ';
        $strQuery .= $neDb->quote(neCheckText($original['title'],'plain')).', ';
        $strQuery .= $neDb->quote(neCheckText($original['content_group'],'plain')).', ';
        $strQuery .= $neDb->quote(neCheckText($original['content'],'html')).', ';
        $strQuery .= $neDb->quote(neCheckText($original['author'])).', ';
        $strQuery .= $neDb->quote(neCheckText($original['changed']));
        $strQuery .= ')';
        $result = $neDbWrite->query($strQuery);
        neGetDbError($result, __FILE__, __LINE__,$strQuery);

        $strQuery  = 'UPDATE '.$neConfig['db']['prefix'].'_content ';
        $strQuery .= "SET title=$strTitle, ";
        $strQuery .= "content=$strContent, ";
        $strQuery .= "author=$strAuthor, ";       
        $strQuery .= "content_group=$strGroup ";       
        $strQuery .= "WHERE page_name=$strName";
    } else {
        $strQuery  = 'INSERT INTO '.$neConfig['db']['prefix'].'_content';
        $strQuery .= '(page_name,title,content,author,active,content_group) ';
        $strQuery .= "VALUES($strName,$strTitle,$strContent,$strAuthor,'0',$strGroup)";
    }
    $result = $neDbWrite->query($strQuery);
    neGetDbError($result, __FILE__, __LINE__,$strQuery);
    return true;
}

/**
* removes the Site from the Database.
*/
function deletePage($strName,$bolConfirmed = false) 
{
    global $neConfig, $neDb, $neDbWrite, $neModuleName, $neTheme;
   if ($bolConfirmed == true) {
        $strQuery  = 'DELETE FROM '.$neConfig['db']['prefix'].'_content ';
        $strQuery .= 'WHERE page_name="'.$strName.'" LIMIT 1';
        $result = $neDbWrite->query($strQuery);
        neGetDbError($result, __LINE__, __FILE__);
        neRedirect(MODULE_LOADER.'?mod='.$neModuleName.'&op=admin_content');
    } else {
         $neTheme->drawDialogbox(
         neTranslate('delete_content'),
            '<p type="advice">'.neTranslate('text-delete_content').'</p>'.
            '<form>'.
            '<input type="hidden" name="mod" value="content"/>'.
            '<input type="hidden" name="op" value="delete"/>'.
            '<input type="hidden" name="name" value="'.$strName.'"/>'.
            '<input type="hidden" name="is_confirmed" value="1"/>'.
            '<div align="right">
             <button type="button" onclick="history.back()">'.neTranslate('back').'</button>
             <button type="submit">'.neTranslate('delete').'</button>
             </div>'.
            '</form>'
        );
        $neTheme->drawSite(neTranslate('delete'));
    }
}

/**
 * Sets a Module to active.
 * @param integer Module ID.
 */
function activatePage($strName)
{
    global $neConfig, $neDbWrite, $neTheme;
    $strQuery  = 'UPDATE '.$neConfig['db']['prefix'].'_content ';
    $strQuery .= "SET active='1' WHERE page_name=". $neDbWrite->quote($strName);
    $result = $neDbWrite->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    neRedirect(MODULE_LOADER.'?mod=content');
}


/**
 * Sets a Module to inactive.
 * @param integer Module ID.
 */
function deactivatePage($strName)
{
    global $neConfig, $neDbWrite, $neTheme;
    $strQuery  = 'UPDATE '.$neConfig['db']['prefix'].'_content ';
    $strQuery .= "SET active='0' WHERE page_name=".$neDbWrite->quote($strName);
    $result = $neDbWrite->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    neRedirect(MODULE_LOADER.'?mod=content');
}


function exportPage($strName) {
    global $neConfig, $neDb, $neTheme, $neModuleName;
    $strQuery  = 'SELECT * ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_content ';
    $strQuery .= 'WHERE page_name='.$neDb->quote($strName);
    $page = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
    neGetDbError($page,__LINE__,__FILE__, $strQuery);
    header('Content-Type: application/octet-stream');
    header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT');
    header('Content-Disposition: attachment; filename="'.$page['page_name'].'.html"');
    header('Content-Disposition: inline; filename="'.$page['page_name'].'.html"');
    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
    header('Pragma: public');
    header('Pragma: no-cache');
    ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN">
<html xmlns="http://www.w3.org/1999/xhtml"  xml:lang="<?php echo $neConfig['default']['lang']?>">
<head>
<title><?php echo $page['title']; ?></title>
<meta name="author" content="<?php echo neGetUserName($page['author']); ?>" />
</head> 
<body>
<?php echo neFormatText($page['content'],'html'); ?>
</body>
</html>    
<?php
}

function addPage() {
    global $neConfig, $neDb, $neTheme, $neModuleName,$neSession;
    $strQuery  = 'SELECT page_name ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_content ';
    $strQuery .= "WHERE page_name=".$neDb->quote('index');
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__, $strQuery);
    if ($result->numRows() > 0 ) {
    	$strName=null;
    } else {
    	$strName='index';
    }
    showEditForm(
        $strName,
        null,
        null,
        neGetUserName($neSession->getId())
    );
}


function editPage($strName) {
    global $neConfig, $neDb, $neTheme, $neModuleName;
    $strQuery  = 'SELECT * ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_content ';
    $strQuery .= 'WHERE page_name='.$neDb->quote($strName);
    $result = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
    neGetDbError($result,__LINE__,__FILE__, $strQuery);
    showEditForm(
        $strName,
        neFormatText($result['title'],'plain'),
        neFormatText($result['content'],'html'),
        (int) $result['author'],
        neFormatText($result['content_group'],'plain')
    );
}

/**
*Show the edit Topic Form.
*/
function showEditForm($strName,$strTitle,$strContent,$strAuthor,$strGroup)
{
    global $neConfig, $neDb, $neTheme, $neModuleName;
    $tpl = $neTheme->getTemplate($neModuleName,"edit_page.tpl");
    $neTheme->drawTitle( neTranslate('edit_page') );
    $tpl->setVariable(array(
    'MODULE_LOADER' => MODULE_LOADER,
    'LABEL_EDIT_PAGE' => neTranslate('edit_page'),
    'LABEL_PAGE_NAME'=> neTranslate('page_name'),
    'LABEL_CONTENT_GROUP' => neTranslate('content_group'),
    'LABEL_PAGE_TITLE' => neTranslate('page_title'),
    'LABEL_PAGE_CONTENT' => neTranslate('page_content'),
    'LABEL_BACKTO_CONTENT' => neTranslate('back_to_content'),
    'PAGE_GROUP' => $strGroup,
    'PAGE_NAME' => $strName,
    'PAGE_TITLE' => $strTitle,
    'PAGE_CONTENT' => $neTheme->getHtmlBox('content',$strContent)
    ));
    $tpl->show();
    $neTheme->drawSite($strTitle);
}

?>
