<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* The Block administration Module.
* This Module allows to add,edit and delete Blocks.  
* Blocks are small pieces of HTML or tiny PHP Scripts to add some usefull
* Stuff to your Site.  
*
* @package nukeevent.modules.blocks
* @author $Author: xeniac $
* @version $Revision: 1.5 $
*/

/**
* deletes an Article
* @param integer The ID of the Block you want to delete
*/
function deleteBlock($intId)
{
    global $neConfig, $neDbWrite, $neTheme;
    $strQuery  = 'DELETE FROM '.$neConfig['db']['prefix'].'_blocks ';
    $strQuery .= 'WHERE block_id='.$neDbWrite->quote($intId);
    $result = $neDbWrite->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
}

function drawDeleteQuestion($intId)
{
    global $neConfig, $neDb, $neTheme,$neModuleName;
    $strMessage = '<form method="post" action="'.MODULE_LOADER.'">';
    $strMessage .= '<input type="hidden" name="mod" value="'.$neModuleName.'" />';
    $strMessage .= '<input type="hidden" name="op" value="delete_block" />';
    $strMessage .= '<input type="hidden" name="id" value="'.$intId.'" />';
    $strMessage .= '<input type="hidden" name="confirm" value="1" />';
    $strMessage .= '<p>'.neTranslate('text-really_delete').': ';
    $strMessage .= $intId.'</p>';
    $strMessage .= '<div style="text-align:right">';
	$strMessage .= '<input type="button" value="'.neTranslate('back').'" onclick="history.back()"/>';
	$strMessage .= '<input type="submit" value="'.neTranslate('delete').'" />';
	$strMessage .= '</div></form>';
    $neTheme->drawTitle(neTranslate('delete_block'));
    $neTheme->drawDialogbox(neTranslate('delete_block'),$strMessage);
    $neTheme->drawSite(neTranslate('delete_block'));
}

/**
*/
function drawBlockWeightOptions($default) {
    global $neConfig,$neDb;
    $strQuery = 'SELECT COUNT(weight) ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_blocks';
    $x = $neDb->getOne($strQuery);
    neGetDbError($x,__LINE__,__FILE__,$strQuery);
    for ($i = 1;$i <= $x; $i++) {
        if ($i == $default) {
            echo '<option selected="selected" value="'.$i.'"> '.$i." </option>\n";
        } else {
            echo '<option value="'.$i.'">'.$i."</option>\n";
        }            
    }
}

/**
* draws the optionfields for the block permissions.
* Possible options are all users,registed users and only admins.
* @param integer default the permission that sould be the default value.
*/
function drawBlockPermissionOptions($default){
    ($default == BLOCK_ONLYADMIN) ? ($selected = 'selected="selected"') : 
    ($selected = '');
    echo '<option value="'.BLOCK_ONLYADMIN.'" '.$selected.'>';
    echo neTranslate('only_admins');
    echo '</option>';

    ($default == BLOCK_ONLYREGISTED) ? ($selected = 'selected="selected"') : 
    ($selected = '');
    echo '<option value="'.BLOCK_ONLYREGISTED.'" '.$selected.'>';
    echo neTranslate('only_registed_users');
    echo '</option>';

    ($default == BLOCK_ALLUSERS) ? ($selected = 'selected="selected"') : 
    $selected = '';
    echo '<option value="'.BLOCK_ALLUSERS.'" '.$selected.'>';
    echo neTranslate('all_users');
    echo '</option>';
    return true;
}

/**
* draws the optionfields for the block position.
* Possible options are all left,right and center.
* @param integer default the permission that sould be the default value.
*/
function drawBlockPositionOptions($default){
    echo '<option value="'.BLOCK_LEFT.'" '.$selected.'>';
    echo neTranslate('left');
    echo '</option>';

    $default == BLOCK_CENTER ? $selected = 'selected="selected"' : 
    $selected = '';
    echo '<option value="'.BLOCK_CENTER.'" '.$selected.'>';
    echo neTranslate('center');
    echo '</option>';

    $default == BLOCK_RIGHT ? $selected = 'selected="selected"' : 
    $selected = '';
    echo '<option value="'.BLOCK_RIGHT.'" '.$selected.'>';
    echo neTranslate('right');
    echo '</option>';
}

/**
* draws the optionfields for the block position.
* Possible options are all left,right and center.
* @param integer default the permission that sould be the default value.
*/
function drawBlockmoduleOptions($default){
    $return = '<option> -- </option>';
    if (is_dir(BLOCK_PATH)) {
        $dh = opendir(BLOCK_PATH);
        while (($file = readdir($dh)) !== false) {
            //$return .= '<option name="'.$file.'">'.$file."</option>\n";
            if (preg_match('/^block-([a-z]*)/i',$file,$match)) {
                $return .= '<option name="'.$match[1].'" ';
                if ($match[1] == $default) {
                	$return .= 'selected="selected" ';
                }
                $return .= '>'.$match[1]."</option>\n";
            }
        }
        closedir($dh);
    }
    return $return;
}
/**
* draws the optionfields for the block position.
* Possible options are all left,right and center.
* @param integer default the permission that sould be the default value.
*/
function drawBlockShowOptions($default){
    global $neConfig,$neDb;
    if ($default == 'ALL') {
        $strReturn = '<option value="ALL" selected="selected">';
    } else {
        $strReturn = '<option value="ALL">';
    }
    $strReturn .= neTranslate('all_modules').'</option>';

    if ($default == 'INDEX') {
        $strReturn .= '<option value="INDEX" selected="selected">';
    } else {
        $strReturn .= '<option value="INDEX">';
    }
    $strReturn .= neTranslate('index_site').'</option>';

    $strQuery = 'SELECT name,title FROM '.$neConfig['db']['prefix'].'_modules';
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    while ($module = $result->fetchRow(DB_FETCHMODE_ASSOC) ) {
        if ($default == $module['name']) {
            $strReturn .= '<option value="'.$module['name'].'" selected="selected">';
        } else {
            $strReturn .= '<option value="'.$module['name'].'">';
        }
        $strReturn .= $module['title'].'</option>';
    }
    return $strReturn;
}

/**
 * writes the changes to the database.
 * @param array an array with all tablefields that sould be changed.
 * @param integer the block_id of the block that should be changed.
 * @param boolean set tue true if you want to create a new block
 */
function submitEditBlock($arrBlock,$bolMode=0,$intBlockId=NULL)
{
    global $neConfig, $neDbWrite, $neTheme;
    $arrBlock['title'] = neCheckText($arrBlock['title'],'plain');
    $arrBlock['block_type'] = (int) $arrBlock['block_type'];
    $arrBlock['position'] = (int) $arrBlock['position'];
    $arrBlock['visible'] = (int) $arrBlock['visible'];
    $arrBlock['module'] = neCheckText($arrBlock['module'],'plain');
    $arrBlock['url'] = neChecktext($arrBlock['url']);
    $arrBlock['blockfile'] = neCheckText($arrBlock['blockfile'],'plain');
    $arrBlock['content'] = neCheckText($arrBlock['content'],'html');
    
    $strQuery  = 'UPDATE '.$neConfig['db']['prefix'].'_blocks ';
    $strQuery .= "SET ";
    $strQuery .= 'title='.$neDbWrite->quote($arrBlock['title']).',';
    $strQuery .= 'block_type='.$neDbWrite->quote($arrBlock['block_type']).',';
    $strQuery .= 'position='.$neDbWrite->quote($arrBlock['position']).',';
    $strQuery .= 'visible='.$neDbWrite->quote($arrBlock['visible']).',';
    $strQuery .= 'module='.$neDbWrite->quote($arrBlock['module']).',';
    $strQuery .= 'url='.$neDbWrite->quote($arrBlock['url']).',';
    $strQuery .= 'blockfile='.$neDbWrite->quote($arrBlock['blockfile']).',';
    $strQuery .= 'content='.$neDbWrite->quote($arrBlock['content']).' ';
    $strQuery .= 'WHERE block_id='.$neDbWrite->quote($intBlockId);
    $result = $neDbWrite->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    neRedirect(MODULE_LOADER.'?mod=blocks');
}
/**
* Adds a Block to the Blockstable
*/
function submitAddBlock($arrBlock,$bolMode=0,$intBlockId=NULL){
     global $neConfig, $neDb, $neDbWrite, $neTheme;
    echo '<pre>';
    var_dump($arrBlock);
    echo '</pre>';
    /* Get the next block ID */
    $strQuery   = 'SELECT block_id ';
    $strQuery  .= 'FROM '.$neConfig['db']['prefix'].'_blocks ';
    $strQuery  .= 'ORDER BY block_id DESC LIMIT 1';
    $intBlockId = $neDb->getOne($strQuery)+1;
    neGetDbError($intBlockId,__LINE__,__FILE__);

    /* Add Row into Database */
    $strQuery  = 'INSERT INTO '.$neConfig['db']['prefix'].'_blocks';
    $strQuery .= '(block_id,title,block_type,position,visible,url,blockfile,content) ';
    $strQuery .= 'VALUES(';
    $strQuery .= "$intBlockId,";
    $strQuery .= "'$arrBlock[title]',";
    $strQuery .= "'$arrBlock[block_type]',";
    $strQuery .= "'$arrBlock[position]',";
    $strQuery .= "'$arrBlock[visible]',";
    $strQuery .= "'$arrBlock[url]',";
    $strQuery .= "'$arrBlock[blockfile]',";
    $strQuery .= "'$arrBlock[content]' ";
    $strQuery .= ')';
    $result = $neDbWrite->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    $neTheme->drawSite();
    //neRedirect('admin.php?mod='.MODULE_NAME.'&op=edit_block&id='.$intBlockId);
}

/**
 * Sets a Block to active.
 * @param integer Module ID.
 */
function activateBlock($intId)
{
    global $neConfig, $neDb, $neDbWrite, $neTheme;
    $strQuery  = 'UPDATE '.$neConfig['db']['prefix'].'_blocks '; 
    $strQuery .= "SET active='1' ";
    $strQuery .= "WHERE block_id='$intId'";
    $result = $neDbWrite->query($strQuery);
    if (DB::isError($result)) {
        $neTheme->drawErrorpage(
            $result->getMessage(),
            $result->getMessage()
        );
    } else {
        neRedirect('admin.php?mod=blocks');
    }
}


/**
 * Sets a Module to inactive.
 * @param integer Module ID.
 */
function deactivateBlock($intId)
{
    global $neConfig, $neDb, $neDbWrite, $neTheme;
    $strQuery  = 'UPDATE '.$neConfig['db']['prefix'].'_blocks '; 
    $strQuery .= "SET active='0' ";
    $strQuery .= "WHERE block_id='$intId'";
    $result = $neDbWrite->query($strQuery);
    if (DB::isError($result)) {
        $neTheme->drawErrorpage(
            $result->getMessage(),
            $result->getMessage()
        );
    } else {
        neRedirect('admin.php?mod=blocks');
    }
}

/**
 * Changes the Access Permissions from the Modules
 */
function changeBlockSettings($arrPermissions,$arrWeight)
{
    global $neConfig, $neDb, $neDbWrite, $neTheme;
    foreach($arrPermissions as $intId => $intView) {
        $strQuery = "UPDATE ".$neConfig['db']['prefix']."_blocks SET visible='$intView' ";
        $strQuery.= "WHERE block_id='$intId'";
        $result = $neDbWrite->query($strQuery);
        neGetDbError($result,__LINE__,__FILE__,$strQuery);
    }
    
    foreach($arrWeight as $intId => $intWeight) {
        $strQuery = "UPDATE ".$neConfig['db']['prefix']."_blocks SET  weight='$intWeight' ";
        $strQuery.= "WHERE block_id='$intId'";
        echo "$strQuery<br/>";

        $result = $neDbWrite->query($strQuery);
        neGetDbError($result,__LINE__,__FILE__,$strQuery);
    }
}


/**
 * A function to edit some Parameter of a Module
 */
function addBlock()
{
    global $neConfig, $neTheme;   
    $arrBlock = array(
        'title'=> 'type the title here',
        'block_type'=>'1',
        'content' => '',
		        
    );
    $neTheme->drawTitle(neTranslate('add_block'));
    drawBlockForm($arrBlock,'submit_add',null);
    $neTheme->drawSite();
}

/**
 * A function to edit some Parameter of a Module
 */
function editBlock($intBlockId)
{
    global $neConfig, $neDb, $neTheme;   
    $bolMode = 0;
    $strQuery  = 'SELECT * ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_blocks ';
    $strQuery .= "WHERE block_id = '$intBlockId'";
    $block = $neDb->getRow($strQuery, DB_FETCHMODE_ASSOC);
    neGetDbError($block,__LINE__,__FILE__,$strQuery);
    $intBlockId = (int) $block['block_id'];
    $neTheme->drawTitle(neTranslate($block['title']));
    drawBlockForm($block,'submit_edit',$intBlockId);
    $neTheme->drawSite();
}


function drawBlockForm($block,$strOp,$intBlockId)
{
	global $neModuleName,$neTheme; 
   ?>
  <form method="post">
  <input type="hidden" name="mod" value="<?=$neModuleName?>" />
  <input type="hidden" name="op" value="<?=$strOp?>" />
  <input type="hidden" name="id" value="<?=$intBlockId?>" />

  <table class="formtable" cellpadding="0" cellspacing="0">
   <tr><td class="formheader" colspan="2"><?= neTranslate('edit Block');?></td></tr>
   <tr class="formtable">
    <td class="formdescr"><?= neTranslate('Blocktitle')?></td>
    <td class="formelement">
     <input type="text" class="text" name="block[title]" value="<?=$block['title']?>" size="60"/>
    </td>
   </tr>
   <tr class="formtable">
   <td class="formdescr"><?= neTranslate('Block position');?></td>
    <td class="formelement">
     <select name="block[position]" class="select">
     <?=drawBlockpositionOptions($block['position']);?>
    </select></td>
   </tr>

   <tr class="formtable">
    <td class="formdescr"><?= neTranslate('Visible for');?></td>
    <td class="formelement">
     <select name="block[visible]">
     <?=drawBlockpermissionOptions($block['visible']);?>
     </select>
     </td>
   </tr>

   <tr class="formtable">
    <td class="formdescr"><?= neTranslate('show_on');?></td>
    <td class="formelement">
     <select name="block[module]">
     <?=drawBlockShowOptions($block['module']);?>
     </select>
     </td>
   </tr>

   <tr class="formtable">
   <td class="formheader" colspan="2"><?= neTranslate('Block type')?></td>
   </tr>
   <tr class="formtable">
    <td class="formdescr">
     <input type="radio" class="radio" name="block[block_type]" value="0"
     <?php if ($block['block_type'] == 0) echo 'checked="checked"';?> />
     <?= neTranslate('Block Module');?></td>
    <td class="formelement">
    <select class="select" name="block[blockfile]">
     <?=drawBlockmoduleOptions($block['blockfile']);?>
    </select>
    </td>
   </tr>
   <tr class="formtable">
    <td class="formdescr">
    <input type="radio" class="radio" name="block[block_type]" value="2"
    <?php if ($block['block_type'] == 2) echo 'checked="checked"';?> />
    <?= neTranslate('RSS Newsfeed')?>
    </td>
    <td class="formelement">
     <input type="text" name="block[url]" value="<?=$block['url']?>" class="text" size="60" />
    </td>
   </tr>
   <tr class="formtable">
    <td class="formdescr">
    <input type="radio" class="radio" name="block[block_type]" value="1"
    <?php if ($block['block_type'] == 1) echo 'checked="checked" ';?> />
    <?= neTranslate('HTML Block')?>
    </td>
    <td class="formelement">
     <?= $neTheme->getHtmlBox('block[content]',$block['content']);?>
    </td>
   </tr>
   <tr class="formtable">
    <td class="formbuttons" colspan="2">
     <input type="reset">
     <input type="submit">
    </td>
   </tr>
  </table>
</form>
    <?php
}

/**
 * Shows a Table with the all Blocks. to sort them.
 */
function adminBlocks()
{
    global $neConfig, $neDb, $neTheme,$neModuleName;
    $neTheme->drawTitle(neTranslate('blocks_admin'));
    echo '<h3>'.neTranslate('Left Blocks').'</h3>';
    drawBlocksTable(BLOCK_LEFT);
    echo '<h3>'.neTranslate('Center Blocks').'</h3>';
    drawBlocksTable(BLOCK_CENTER);
    echo '<h3>'.neTranslate('Right Blocks').'</h3>';
    drawBlocksTable(BLOCK_RIGHT);
    $neTheme->DrawSite();
}

function drawBlocksTable($position){
    global $neConfig, $neDb,$neTheme,$neModuleName;
    $strModulesTable = $neConfig['db']['prefix'].'_blocks';
    $strQuery  = 'SELECT block_id, title, weight, language, visible, active, position, module ';
    $strQuery .= 'FROM '.$strModulesTable.' ';
    $strQuery .= 'WHERE position=\''.$position.'\' ';
    $strQuery .= 'ORDER BY weight';
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__);
    ?>
    <form action="<?php echo MODULE_LOADER;?>" method="post">
    <input type="hidden" name="mod" value="<?php echo $neModuleName;?>" />
    <input type="hidden" name="op" value="change_blocks" />
    <table class="tableview" width="100%">
     <tr class="tableview">
      <th class="tableview"><?php echo neTranslate('sequence');?></th>
      <th class="tableview"><?php echo neTranslate('title');?></th>
      <th class="tableview"><?php echo neTranslate('show_in');?></th>
      <th class="tableview"><?php echo neTranslate('active');?></th>
      <th class="tableview"><?php echo neTranslate('visible_for');?></th>
      <th class="tableview"><?php echo neTranslate('functions');?></th>
     </tr>
    <?php
    $class = '';
    while ($block = $result->fetchRow(DB_FETCHMODE_ASSOC) ){
     ?>
     <tr class="tableview">
      <td class="tableview">
       <select class="select" name="weight[<?=$block['block_id']?>]">
        <?=drawBlockWeightOptions($block['weight']);?>
       </select>
      </td>
      <td class="tableview">
       <?php echo $block['title'];?>
      </td>
      <td class="tableview">
       <?php echo $block['module'];?>
      </td>
      <td align="center" class="tableview"><?php
      if ($block['active'] == 1 ) {
          echo '<a href="'.MODULE_LOADER.'?mod=blocks&amp;op=deactivate&amp;id='.$block['block_id'].'">';
          $neTheme->drawImage('ledgreen',neTranslate('active'));
          echo '</a>';
      } else {
          echo '<a href="'.MODULE_LOADER.'?mod=blocks&amp;op=activate&amp;id='.$block['block_id'].'">';
          $neTheme->drawImage('ledred',neTranslate('inactive'));
          echo '</a>';
      }
      ?>
      </td>
      <td class="tableview">
       <?php
        echo '<select name="visible['.$block['block_id'].']">';
        drawBlockpermissionOptions($block['visible']);
        echo '</select>';
       ?>
      </td>
      <td class="tableview" align="right">
       <a href="admin.php?mod=blocks&amp;op=edit_block&amp;id=<?php echo $block['block_id'];?>">
        <?php echo $neTheme->drawImage('edit',neTranslate('edit'));?>
       </a>
       <a href="admin.php?mod=blocks&amp;op=delete_block&amp;id=<?php echo $block['block_id'];?>">
        <?php echo $neTheme->drawImage('delete',neTranslate('delete'));?>
       </a>
      </td>
     </tr>
     <?php
    }
     ?>
     <tr>
      <td colspan="8" class="formbuttons">
       <button type="button" onclick="location.href='admin.php?mod=blocks&amp;op=add'"><?php echo neTranslate('add_block')?></button>
       <button type="submit"><?php echo neTranslate('change_settings')?></button>
      </td>
     </tr>
    </table>
   </form>
   <?php
}
?>
