<?php
/*
    This file is part of NukeEvent.

    NukeEvent is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    NukeEvent is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Foobar; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* NukeEvent Bsic Theme
*
* This class will be inherited by the theme.class.php of the used theme.
* Maybe it is a little confusing but with this technique a Theme Author could
* add functionality to a Theme without the need to 
*
* @Author $Author: xeniac $
* @License GPL
* @version $Revision: 1.7 $
* @Package nukeevent
*/

class NukeEventBaseTheme
{
    var $theme;
    var $template;
    /**
    * the Constructor
    */
    function NukeEventBaseTheme($strTheme)
    {
        /*
         * Start Output Buffering.
         * It helps to reduce some Errors when sending Headers and after warning
         * Messages. Also i don't have to rewrite the Complete Code. :)
         */
        ob_start();
        $this->theme = $strTheme;
        $this->template = new HTML_template_ITX(THEME_PATH.$strTheme);
    }

    function _parseRSS($strURI,$strBlockname)
    {
    	require_once('includes/rss_parser.class.php');
    	$parser = new RssParser;
        $parser->setRssFile(DATA_PATH.$strBlockname.'.rdf');
		$parser->setRssUrl($strURI);
		$parser->parseData();
		$items = $parser->getItems();
		$strReturn = "<p>";
		foreach ($items as $item) {
			$strReturn .= '<a href="'.$item['link'].'">'.$item['title'].'</a><br/>';
		}
		$strReturn .= "</p>";
		return $strReturn;
    }
    
     /**
    * Executes an block-xxx-.php File and returns the result.
    * @access private
    */
    function _includeBlockfile($blockfile)
    {
        $file = file("blocks/block-$blockfile.php");
        if (!$file) {
            $strContent = neTranslate('blockfile-not-exists').'<br/>'."blocks/block-$blockfile.php";
        } else {
            include("blocks/block-$blockfile.php");
        }
        if ( empty($strContent) ){
            $strContent = neTranslate('blockfile-no-output');
        }
        return $strContent;
    }


    /**
    * @access private
    */
    function _drawBlocks()
    {
        global $neConfig, $neSession, $neDb, $neModuleName, $neOp,
               $neModuleLoader,$neTheme;
        /*Build the Querystring */
        $strQuery  = 'SELECT block_id, visible, position, block_type, title, ';
        $strQuery .= 'content, url, blockfile ';
        $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_blocks ';
        $strQuery .= "WHERE active='1' ";
        $strQuery .= "AND (module='ALL' ";
        if (MODULE_LOADER == 'admin.php') {
            $strQuery .= 'OR module=\'admin\' ';
        } elseif (MODULE_LOADER == 'index.php' and empty($_GLOBALS['mod'])){
            $strQuery .= "OR module='INDEX' ";
        }
        $strQuery .= "OR module='$neModuleName') ";
        $strQuery .= 'ORDER BY weight ASC';

        /*get the Result abort if an error occours*/
        $blocks_result = $neDb->query($strQuery);
        if ( DB::isError($blocks_result) ) {
            trigger_error($blocks_result->getMessage(),E_USER_ERROR);
            return false;
        }

        while($blocks_result->fetchInto($block,DB_FETCHMODE_ASSOC) ) {
            if (
                ( $block['visible'] >= BLOCK_ONLYADMIN and $neSession->isAdmin() ) or
                ( $block['visible'] >= BLOCK_ONLYREGISTED and $neSession->isLoggedIn() ) or
                ( $block['visible'] >= BLOCK_ALLUSERS )
               )
            {
                switch($block['block_type']){
                /*RSS Newsfeed*/
                case BLOCK_RSSFEED:
                    $block['content'] = $this->_parseRSS($block['url'],$block['title']);
                    break;
                /*Blockmodule*/
                case BLOCK_BLOCKMODULE:
                    $block['content'] = $this->_includeBlockfile($block['blockfile']);
                    break;
                /*HTML Formatted Content*/
                case BLOCK_HTMLBLOCK:
                    $block['content'] = neFormatText($block['content'],'html');
                    break;
                }
				if ($neSession->isAdmin('blocks')) {
					$block['content'] .= '<div style="text-align:right">';
					$block['content'] .= '<a href="'.MODULE_LOADER;
					$block['content'] .= '?mod=blocks&amp;op=edit_block&amp;id=';
					$block['content'] .= $block['block_id'].'">';
					$block['content'] .= $this->getImage('edit',neTranslate('edit'));
					$block['content'] .= '</a></div>';
				}
                switch ($block['position']) {
                   case BLOCK_LEFT:
                        $this->drawLeftBlock($block['title'],$block['content']);
                    break;
                  case BLOCK_RIGHT:
                        $this->drawRightBlock($block['title'],$block['content']);
                    break;
                  case BLOCK_CENTER:
                        $this->drawCenterBlock($block['title'],$block['content']);
                    break;
                }
            }//if
        }//while
        $blocks_result->free();
    }

    /**
    * @access private
    */
    function _drawAdminMenu() {
        global $neConfig, $neSession, $neDb, $neModuleName;
        $strAdminmenuTable = $neConfig['db']['prefix'].'_admin_menu';
        $strQuery  = "SELECT DISTINCT menu.module, module.title ";
        $strQuery .= "FROM ".$neConfig['db']['prefix'].'_admin_menu menu, ';
        $strQuery .=         $neConfig['db']['prefix'].'_modules module ';
        $strQuery .= "WHERE module.name = menu.module ";
        $strQuery .= "ORDER BY menu.module";

        $menu_result = $neDb->query($strQuery);
        if (DB::isError($menu_result)){
            trigger_error($menu_result->getMessage(),E_USER_ERROR);
            return(false);
        }
        while (list($strModuleName, $strModuleTitle) = $menu_result->fetchRow()){
            if ( $neSession->isAdmin($strModuleName) ) {
                $this->template->setVariable('MODULE_LINK',MODULE_LOADER.'?mod='.$strModuleName);
                $this->template->setVariable('MODULE_TITLE',neTranslate($strModuleTitle,true));
                if ($neModuleName == $strModuleName ) {
                    $strQuery   = "SELECT text, op ";
                    $strQuery  .= "FROM  $strAdminmenuTable ";
                    $strQuery  .= "WHERE module='$strModuleName' ";
                    $strQuery  .= "ORDER BY weight";
                    $entry_result = $neDb->query($strQuery);
                    if (DB::isError($entry_result)){
                        echo $strQuery;
                        break;
                    }
                    $this->template->setCurrentBlock('function');
                    while (list($strText, $strOp) = $entry_result->fetchRow()){
                        $this->template->setVariable('FUNCTION_LINK',MODULE_LOADER.'?mod='.$strModuleName.'&amp;op='.$strOp);
                        $this->template->setVariable('FUNCTION_NAME',neTranslate($strText,true));
                        $this->template->parse('function');
                    }
                    $entry_result->free();
                }
                $this->template->parse('module');
            }
        }
    }


    function getTemplate($strModulename,$strFile){
    global $neSession,$neModuleName;
        if (file_exists(THEME_PATH.$this->theme.'/'.$strModulename.'/'.$strFile)) {
            $new_template = new HTML_template_IT(THEME_PATH.$this->theme.'/'.$strModulename);
        } elseif (file_exists(MODULES_PATH.$strModulename.'/theme')) {
            $new_template = new HTML_template_IT(MODULES_PATH.$strModulename.'/theme');
        } else {
        	trigger_error("NukeEventBaseTheme::getTemplate: $strFile does not exist",E_USER_ERROR);
            neDrawError("template_does_not_exist");
        }
        $new_template->loadTemplateFile($strFile);
        return $new_template;
    }
 

    /**
    * Load the Template File for the Module
    */
    function setTemplate($strTemplateName){
        $this->template->loadTemplateFile($strTemplateName);
    }


    /**
    *draws an     Errorpage
    */
    function drawErrorpage($strTitle, $strDescription)
    {
        global $neConfig;
        $tpl = new HTML_template_IT(THEME_PATH.$this->theme) or die("$strTitle");
        $tpl->loadTemplateFile('error.tpl')or die("$strTitle");
        $tpl->setVariable(array(
            'ERROR_TITLE' => neFormatText($strTitle,'plain'),
            'ERROR_DESCRIPTION' => neFormatText($strDescription,'html'),
            'ERROR_IMAGE' => $this->getImageSrc('error'),
            'LABEL_INDEX'=> neTranslate('index'), 
            'LABEL_RELOAD' => neTranslate('reload'),
            'LABEL_BACK' => neTranslate('back'),
            'LINK_BACK' => "javascript:history.back()",
            'LINK_RELOAD' => 'javascript:site.reload()',
            'LINK_INDEX' => $neConfig['site']['url']
        ));
        $tpl->parse();
        $tpl->show();
        unset($tpl);
        $this->drawSite($strTitle);
        die();
    }


    /**
    *draw a left Box
    * @access private
    */
    function drawLeftBlock($strTitle,$strContent){
        $this->template->setCurrentBlock('leftblock');
        $this->template->setVariable('BLOCKTITLE',$strTitle);
        $this->template->setVariable('BLOCKCONTENT',$strContent);
        $this->template->parse('leftblock');
    }

    /**
    *draw a left Box
    * @access private
    */
    function drawRightBlock($strTitle,$strContent){
        $this->template->setCurrentBlock('rightblock');
        $this->template->setVariable('BLOCKTITLE',$strTitle);
        $this->template->setVariable('BLOCKCONTENT',$strContent);
        $this->template->parse('rightblock');
    }

    /**
    *draw a centerblock
    * @access private
    */
    function drawCenterBlock($strTitle,$strContent){
        $this->template->setCurrentBlock('centerblock');
        $this->template->setVariable('BLOCKTITLE',$strTitle);
        $this->template->setVariable('BLOCKCONTENT',$strContent);
        $this->template->parse('centerblock');
    }



    function getHelplink($strName,$strModule,$strFile,$strAnchor = NULL){
        $strHelplink  ='help.php?mod='.urlencode($strModule);
        $strHelplink .='&amp;file='.urlencode($strFile);
        if ( !empty($strAnchor) ) {
            $strHelplink .='#'.urlencode($strAnchor);
        }
        $strJavaScript="popHelp('$strHelplink')";
        return '<a href="'.$strHelplink.'" onclick="popHelp(\''.$strHelplink.'\')" target="help">'.$strName.'</a>';
    }

    /**
    * draws an Title
    */
    function drawTitle($strTitle)
    {
        $this->template->setVariable('SITE_TITLE',$strTitle);
    }


    /**
    * draws an Dialog box
    */
    function drawDialogbox($strTitle, $strContent)
    {
        $this->template->setCurrentBlock('messagebox');
        $this->template->setVariable('TITLE',$strTitle);
        $this->template->setVariable('CONTENT',$strContent);
        $this->template->parse('messagebox');
    }

    /**
    * gets the Output from the Buffer, and draws the Complete Site.
   * @param string pagetitle
   */
    function drawSite($pagetitle='',$metatags=false) {
        global $neConfig, $neSession, $starttime, $neErrors,$neModuleLoader;
        if ( is_array($metatags) ) {
            foreach ($metatags as $name => $value ) {
                $neConfig['meta'][$name] = $value;
            }
        }
        $strMetaTags = '';
		foreach ($neConfig['meta'] as $name => $value) {
		   $strMetaTags .= '<meta name="'.$name.'" content="'.$value.'" />'."\n";
		}
        $strMainContent = ob_get_contents();
        ob_end_clean();
        if (MODULE_LOADER == 'index.php') {        
            $this->_drawBlocks();
        }    
        if (MODULE_LOADER == 'admin.php'){
            $this->_drawAdminmenu();
        }
        $strFooterMsg = '';
        unset($strFooter);
        $timeparts = explode(' ',microtime());
        $endtime = $timeparts[1].substr($timeparts[0],1);

        $this->template->setVariable(array(
            'USERNAME' => $neSession->getName(),
        	'SITENAME' => $neConfig['site']['name'],
        	'PAGETITLE' => $pagetitle,
        	'METATAGS' => $strMetaTags,
        	'THEME' => $this->theme,
        	'MAINCONTENT' => $strMainContent,
        	'FOOTER' => $neConfig['site']['footer'],
        	'EXECUTION_TIME' => $endtime - $starttime
        ));
       if (is_array($neErrors) AND $neSession->isSuperUser()) {
       	   $this->template->setVariable(array(
               'LABEL_ERROR_TYPE' => neTranslate('error_type'),
               'LABEL_ERROR_MESSAGE' => neTranslate('error_message'),
               'LABEL_ERROR_FILE' => neTranslate('file'),
               'LABEL_ERROR_LINE' => neTranslate('line'),       	   
       	   ));
       	   $this->template->setCurrentBlock('error');
           foreach($neErrors as $error ) { 
               $this->template->setVariable(array(
               'ERROR_TYPE' => $error['type'],
               'ERROR_MESSAGE' => $error['message'],
               'ERROR_FILE' => $error['file'],
               'ERROR_LINE' => $error['line'],
               ));
               $this->template->parse('error');
            }
       }    
        $this->template->show();
    }
    
    
    /**
    * Returns an Image Tag with the Image
    */
    function getImageSrc($strImageName, $strImagePath='')
    {
        global $neSession;
        if (empty($strImagePath)) {
            $strImagePath = IMAGE_PATH;
            if(file_exists(THEME_PATH.$this->theme.'/images/'.$strImageName.'.png')){
                $strImageName = THEME_PATH.$this->theme.'/images/'.$strImageName.'.png';
            } elseif(file_exists(THEME_PATH.$this->theme.'/images/'.$strImageName.'.jpg')){
                $strImageName = THEME_PATH.$this->theme.'/images/'.$strImageName.'.jpg';
            } elseif(file_exists(THEME_PATH.$this->theme.'/images/'.$strImageName.'.gif')){
                $strImageName = THEME_PATH.$this->theme.'/images/'.$strImageName.'.gif';
            } elseif(file_exists($strImagePath.$strImageName.'.png')){
                $strImageName = $strImagePath.$strImageName.'.png';
            } elseif(file_exists($strImagePath.$strImageName.'.jpg')){
                $strImageName = $strImagePath.$strImageName.'.jpg';
            } elseif(file_exists($strImagePath.$strImageName.'.gif')){
                $strImageName = $strImagePath.$strImageName.'.gif';
            } else {
                trigger_error("$strImagePath$strImageName.* does not exist",E_USER_NOTICE);
                return false;
            }
        } else {         
            if(file_exists($strImagePath.$strImageName.'.png')){
                $strImageName = $strImagePath.$strImageName.'.png';
            } elseif(file_exists($strImagePath.$strImageName.'.jpg')){
                $strImageName = $strImagePath.$strImageName.'.jpg';
            } elseif(file_exists($strImagePath.$strImageName.'.gif')){
                $strImageName = $strImagePath.$strImageName.'.gif';
            } else {
                return false;
            }        
        }
        return $strImageName;
    }

    function getImage($strImageName, $strAltText,$strImagePath='')
    {
        $strImageName= $this->getImageSrc($strImageName,$strImagePath);
        @$size = getimagesize ($strImageName);
        return '<img src="'.$strImageName.'" '.$size[3].' alt="'.$strAltText.'" title="'.$strAltText.'" border="0" />';
    }

    function drawImage($strImageName, $strAlttext,$strImagePath='')
    {
        echo $this->getImage($strImageName, $strAlttext,$strImagePath);
    }

    function getUserinfo($intUserId){
        return neGetUserName($intUserId);
    }

    function getHtmlBox($strName,$strContent)
    {
    return '<textarea style="width:100%" rows="20" cols="60" class="htmlarea" name="'.$strName.'"
     id="'.$strName.'">'.htmlentities($strContent).'</textarea>';
    }

    function getUbbBox($strName,$strContent,$intRows=10,$intCols=50)
    {
        $return = '<script type="text/javascript" src="javascript/ubbeditor.js" language="JavaScript"></script>';
        $return .= '<div class="toolbar">';

        $return .= '<a href="javascript:insertUbb(\'b\',\''.$strName.'\')">';
        $return .= $this->getImage('ubb_editor/bold',neTranslate('bold'));
        $return .= '</a>';

        $return .= '<a href="javascript:insertUbb(\'i\',\''.$strName.'\')">';
        $return .= $this->getImage('ubb_editor/italic',neTranslate('italic'));
        $return .= '</a>';

        $return .= '<a href="javascript:insertUbb(\'u\',\''.$strName.'\')">';
        $return .= $this->getImage('ubb_editor/underline',neTranslate('underline'));
        $return .= '</a>';

        $return .= '<a href="javascript:insertUbb(\'s\',\''.$strName.'\')">';
        $return .= $this->getImage('ubb_editor/strike',neTranslate('strikethrought'));
        $return .= '</a>';

        $return .= '<a href="javascript:insertUbb(\'sup\',\''.$strName.'\')">';
        $return .= $this->getImage('ubb_editor/sup',neTranslate('superscript'));
        $return .= '</a>';

        $return .= '<a href="javascript:insertUbb(\'sub\',\''.$strName.'\')">';
        $return .= $this->getImage('ubb_editor/sub',neTranslate('subscript'));
        $return .= '</a>';

        $return .= '<a href="javascript:insertImage(\''.$strName.'\')">';
        $return .= $this->getImage('ubb_editor/image',neTranslate('insert image'));
        $return .= '</a>';
        
        $return .= '</div>';
        $return .=  '<textarea rows="'.$intRows.'" cols="'.$intCols.'" class="ubbarea" id="'.$strName.'" name="'.$strName.'" style="width:100%">';
        $return .=  $strContent;
        $return .=  '</textarea>'."\n";
        return $return;
    }


}
?>
