<?php
/*
    This file is part of NukeEvent.

    NukeEvent is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    NukeEvent is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Foobar; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* Abstraction for NukeEvent Sessions
*
* A Class to handle Sessions and user logins
* This is a abstraction for Sessionhandling and user logins.
* Using a Class for the Userhandlig allows Simple Changes for the Usermangement.
*
* @Author $Author: xeniac $
* @License GPL
* @version $Revision: 1.7 $
* @Package nukeevent
*/
class NukeEventSession
{

    var $userid    = 0;
    var $loggedin  = false;
    var $admin 	   = false;
    var $superuser = false;
    var $username  = '';
    var $password  = '';
    var $theme     = 'default';
    var $lang      = 'c';

    /**
    * Constructor for the NukeEventSession class.
    */
    function NukeEventSession()
    {
        global $neConfig, $neDb;
        //Start a Session with the Name NE_SESS
        session_name('NE_SESS');
        session_start();
        /* if the User is logged in set the User Options*/
        if (isset($_SESSION['user_id']) AND $_SESSION['user_id'] > 0) {
            $strQuery  = 'SELECT * ';
            $strQuery .= 'FROM '.$neConfig['db']['userprefix'].'_users ';
            $strQuery .= "WHERE user_id = '$_SESSION[user_id]' ";
            $userData = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
            if (DB::isError($userData)) {
                trigger_error($userData->getDebugInfo());
            }         
            
            $this->userid    = $userData['user_id'];
            $this->loggedin  = true;
            $this->username  = $userData['user_name'];
            $this->password  = $userData['user_password'];
            $this->theme     = $userData['user_theme'];
            $this->lang      = $userData['user_lang'];
            if($userData['user_admin'] == 1) {
                $this->admin = true;
            }
            if($userData['user_superuser'] == 1) {
                $this->superuser = true;
            }
            unset($strQuery,$userData);
        /* Check if the Login Cookie is set: */
        } elseif (isset($_COOKIE['user_id']) AND $_COOKIE['user_id'] > 0) {
            //Get The Userinfo from the Database.
            $strQuery  = 'SELECT * ';
            $strQuery .= 'FROM '.$neConfig['db']['userprefix'].'_users ';
            $strQuery .= 'WHERE user_id = '.$neDb->quote($_COOKIE['user_id']);
            $userData = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
            if (DB::isError($userData)) {
                 trigger_error($userData->getDebugInfo());
            }          
            if ($_COOKIE['login'] == md5($userData['user_name'].'@'.$userData['user_password'])) {
                $_SESSION['user_id'] = $userData['user_id'];
                $this->userid    = $userData['user_id'];
                $this->loggedin  = true;
                $this->username  = $userData['user_name'];
                $this->password  = $userData['user_password'];
                $this->theme     = $userData['user_theme'];
                $this->lang      = $userData['user_lang'];
                if($userData['user_admin'] == 1) {
                    $this->admin = true;
                }
                if($userData['user_superuser'] == 1) {
                    $this->superuser = true;
                }
            } else {
                $this->userid    = 0;
                $this->loggedin  = false;
                $this->admin     = false;
                $this->superuser = false;
                $this->username  = $neConfig['default']['username'];
                $this->password  = null;
                $this->theme     = $neConfig['default']['thme'];
                $this->lang      = $neConfig['default']['lang'];            
            }
            unset($strQuery,$userData);
        } else {
            $this->userid    = 0;
            $this->loggedin  = false;
            $this->admin = false;
            $this->superuser = false;
            $this->username  = $neConfig['default']['username'];
            $this->password  = null;
            $this->theme     = $neConfig['default']['theme'];
            $this->lang      = $neConfig['default']['lang'];            
        }
    }

   /**
   * Makes a User Login.
   * Check if the Username and Password are Correct.
   * Adds a login Cookie and sets the Userdata.
   */
    function login($strUsername,$strPassword,$bolRemember)
    {
        global $neConfig, $neDb;
        $strUsername = $strUsername;
        $strPassword = $neDb->quote(md5($strPassword));
        $strQuery  = 'SELECT * ';
        $strQuery .= 'FROM '.$neConfig['db']['userprefix'].'_users ';
        $strQuery .= 'WHERE user_name = '.$neDb->quote($strUsername);
        $strQuery .= "AND user_password = $strPassword";
        $result = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
        if (DB::isError($result)) {
            trigger_error($result->getDebugInfo());
        }               
        if (isset($result['user_id']) ) {           
            $_SESSION['user_id'] = $result['user_id'];
	    if ($bolRemember == true) {
                setCookie('user_id',$result['user_id'],time()+60*60*24*30);
                setCookie('login',md5($result['user_name'].'@'.$result['user_password']),time() + 216000);			   
            }
	    return true;
        } else {
            return false;
        }
    }

   /**
   * adds an User to the User Database.
   */
    function addUser($strUsername,$strPassword,$strEmail)
    {
        global $neConfig, $neDb;
        $strUsername = $neDb->quote($strUsername);
        $strPassword = $neDb->quote(md5($strPassword));
        $strQuery  = 'SELECT * ';
        $strQuery .= 'FROM '.$neConfig['db']['userprefix'].'_users ';
        $strQuery .= "WHERE username = $strUsername ";
        $strQuery .= "AND password = $strPassword";
        $result = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
        if (DB::isError($result)) {
            trigger_error($result->getDebugInfo());
        }         
        if ( is_array($result) ) {
            $this->_setSession($result);
	    if ( $bolRemember == true ) {
	        $this->_setCookie($result);
	    }
	    return true;
        } else {
            $this->loginFailed = true;
            $this->_setDefaultValues();
            return false;
        }
    }


    function getPermission() {
        global $neModuleName;
        // The Admin can view all;
        if ($this->isAdmin($neModuleName) ) {
            return 0;
        /**If Module is for Users only, and Uses is logged in */
        } elseif ($this->isLoggedIn()) {
            return 1;
        /** if Module is allowed for Anonymouse */
        } else {
            return 2;
        }
    }
    
    function isAllowed($intPermission) {
        global $neModuleName;
        // The Admin can view all;
        if ($this->isAdmin($neModuleName) ) {
            return true;
        /**If Module is for Users only, and Uses is logged in */
        } elseif ( ($intPermission >= 1) and ($this->isLoggedIn()) ) {
            return true;
        /** if Module is allowed for Anonymouse */
        } elseif ( $intPermission >= 2 ) {
            return true;
        } else {
            return false;
        }
    }

    /**
    * Check if current Session is owned by an logged in User.
    * @return bool true if the User is Logged in, False if Anonymous
    */
    function isLoggedIn() {
        if ( $this->loggedin == true ) {
            return true;
        } else {
            return false;
        }
    }

    /**
    * Check if the current User is an Admin.
    * @return boolean true: if the User is Admin and the Password is correct
    *                 false: if the Password is incorect or the User is no Admin
    */
    function isAdmin($strModuleName=null)
    {
        global $neConfig,$neDb;
        if ( $this->superuser == true ) {
            return true;
	    } elseif ( empty($strModuleName) AND $this->admin == true) {
	        return true;
       } elseif ($this->admin == true ) {
            $strQuery  = 'SELECT module_name FROM '.$neConfig['db']['prefix'].'_admin_permissons ';
            $strQuery .= "WHERE module_name = '$strModuleName' ";
            $strQuery .= 'AND user_id = '.$neDb->quote($this->userid);
            $result = $neDb->getOne($strQuery);
            if (DB::isError($result)) {
                trigger_error($result->getDebugInfo());
            }         
            if ($result == $strModuleName) {
                unset($result);
                return true;
            } else {
                unset($result);
                return false;
            }       
        } else {
                return false;
        }
    }//function isAdmin($strModuleName='')


    function isSuperUser()
    {
        if ( $this->superuser == true ) {
            return true;
        } else {
            return false;
        }
    }


    /**
    * returns the current users selected theme
    */
    function getTheme()
    {
        global $neConfig;
        if (@file_exists('themes/'.$this->theme.'/theme.inc.php') ) {
            return $this->theme;
        } else {
            return $neConfig['default']['theme'];
        }
    }

    function getName()
    {
        return $this->username;
    }

    function getId()
    {
        return $this->userid;
    }


    function getLang()
    {
	    global $neConfig;
        if ( !empty($this->lang) ) {
		    return $this->lang;
		} else {
            return $neConfig['default']['lang'];
		}			
    }

    /**
     * Makes a User Logout.
     * Destroys the Usersession, deltetes the Usercookie
     * and Triggers the NukeEventSession constructor again.
     * @returns boolean true if the Logout suceedes.
     */
    function logout()
    {
        $_SESSION['user_id'] = null;
        session_destroy();
        setCookie('user_id',null,time() - 3600);
        $this->NukeEventSession();
        if ($this->isLoggedin()) {
            return false;
        } else {
            return true;
        }
    }
}
