<?php
/*
    This file is part of NukeEvent.

    NukeEvent is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    NukeEvent is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with NukeEvent; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/**
* This is the legnedary Main-File, it does all the magic.
* This File checks for Security, loads the global Variable Scope.
* Sets some Statics.
* Initializes the NukeEvent-API, the SQL-Layer and watches DBZ if there is
* nothing to do. ;)
*
* @package nukeevent
* @author $Author: xeniac $
* @version $Revision: 1.4 $
*/


/*Benchmarking*/
$timeparts = explode(' ',microtime());
$starttime = $timeparts[1].substr($timeparts[0],1);

/**
*define Constants for NukeEvent
*/
define('BLOCK_LEFT', 1);
define('BLOCK_CENTER', 2);
define('BLOCK_RIGHT', 3);
define('BLOCK_ONLYADMIN', 0);
define('BLOCK_ONLYREGISTED', 1);
define('BLOCK_ALLUSERS', 2);

define('BLOCK_BLOCKMODULE', 0);
define('BLOCK_RSSFEED', 2);
define('BLOCK_HTMLBLOCK', 1);

define('BLOCK_PATH','blocks/');
define('DATA_PATH','data/');
define('IMAGE_PATH','images/');
define('INCLUDE_PATH','includes/');
define('MODULES_PATH','modules/');
define('THEME_PATH','themes/');

/**
* load the Config File.
*/
require_once('config.inc.php');

/* Change the includepath if needet*/
if ($neConfig['include']['change'] == true) {
    ini_set('include_path', $neConfig['include']['path']);
}

//TODO: Diese Einstellungen sollten immer geschehen, nur im Safemode nicht.
/* Change the includepath if needet*/
if ($neConfig['include']['change'] == true) {
    ini_set('track_vars', true);
    ini_set('register_globals', false);
    ini_set('register_long_arrays', false);
}

/**
* include the File with the common API Functions.
*/
require_once(INCLUDE_PATH.'functions.inc.php');

/**
* include the file with the Session Class.
*/
require_once(INCLUDE_PATH.'session.class.php');

/**
* include the file with the base Theme.
*/
require_once(INCLUDE_PATH.'theme.class.php');

/**
* include the debug fetures if debug-enabled is set to true.
*/
//TODO: Debugging noch mal testen.
if ( $neConfig['debug']['enabled'] == true) {   
    include_once(INCLUDE_PATH.'/debug.inc.php');
    error_reporting(E_ALL); //Report all Errors
} else {
    error_reporting(0);
}
set_error_handler("neErrorHandler");

/**
 * load the DB-Class from the PEAR Repository.
 * @see http://pear.php.net
 */
require_once('DB.php');

/**
 * load the HTML_Template_ITX Template Class from the PEAR Repository.
 * @see http://pear.php.net
 */
require_once('HTML/Template/ITX.php');

/*Connect to the Database - Readable Access*/
$neDb = DB::connect($neConfig['db']['uri']);

/*Connect to the Database - Writeable Access*/
$neDbWrite = DB::connect($neConfig['db']['uri_write']);

/*Put an Error if Connection fails*/
if ( DB::isError($neDb)) {
    echo '<h1>'.$neDb->getMessage().'</h1>';
    echo '<p>'.neTranslate(DB::errorMessage($neDb), true).'</p>';
    echo '<tt>'.$neDb->getDebugInfo().'</tt>';
    die();
}

$neSession = new NukeEventSession();
include_once(THEME_PATH.$neSession->getTheme().'/theme.class.php');
$neTheme = new NukeEventTheme($neSession->getTheme()) or die('cant init theme');
neGetLang('nukeevent');

ob_start();

if (!is_writable(DATA_PATH)) {
	trigger_error(DATA_PATH.' is not writeable');
}
?>
