<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Foobar; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/**
* The Admin Console.
* @package nukeevent
* @author $Author: xeniac $
* @version $Revision: 1.4 $
*/

/** include the mainfunctions file */
require_once("includes/mainfile.inc.php");

/** include the admin functions file */
require_once("includes/admin_functions.inc.php");

define('MODULE_LOADER','admin.php');

$neTheme->setTemplate('admin.tpl');
//neGetLang('admin');
if (isset($_POST['op'])) {
    $neOp = $_POST['op'];
} elseif (isset($_GET['op'])) {
    $neOp = $_GET['op'];
} else {
    $neOp = null;
}

if (isset($_POST['mod'])) {
    $neModuleName = neCheckText($_POST['mod']);
} elseif (isset($_GET['mod'])) {
    $neModuleName = neCheckText($_GET['mod']);
} else {
    $neModuleName = $neConfig['default']['module'];
}


/*==Admin Module Loader======================================================*/
/*Only proceed if the Module is set*/
if( $neSession->IsAdmin() ) {
    $strModuleFile = 'modules/'.$neModuleName.'/index.php';
    /*Hack Check: if the modulename contains a "/" or a "." Abort.*/
    if ( preg_match("/(\.|\/)/",$neModuleName) ){
        echo "Hackalarm!!!";
        die();
    }
    if (file_exists($strModuleFile)) {
        include($strModuleFile);
    } else {
        $neTheme->drawErrorpage(
        neTranslate('title-module_is_inactive'),
        neTranslate('message-module_is_inactive')
        );
    }
    
    /*If not an Admin*/
} else {
    switch ($neOp) {
        case 'check_login':
        var_dump($_POST);
        if ( isset($_POST['remember']) && ($_POST['remember'] == 1 or $_POST['remember'] == 'on')) {
            trigger_error("Remember Login ($_POST[remember])",E_USER_NOTICE);
            $bolRemember = true;
        } else {
            trigger_error("Dont remember Login ($_POST[remember])",E_USER_NOTICE);
            $bolRemember = false;
        }
        checkAdminLogin($_POST['uname'],$_POST['pass'],$_POST['remember']);
        break;
        default:
        //header('WWW-Authenticate: Basic realm="'.$neConfig['site']['name'].'"');
        //header('HTTP/1.0 401 Unauthorized');       
        displayAdminLogin();
        break;
    }
}
?>
