/*
 * Decompiled with CFR 0.152.
 */
package irc.style;

import irc.IRCConfiguration;
import irc.ListenerGroup;
import irc.StyleContext;
import irc.style.ChannelRecognizer;
import irc.style.DecodedLine;
import irc.style.DrawResult;
import irc.style.DrawResultItem;
import irc.style.FormattedStringDrawer;
import irc.style.FormattedStringDrawerListener;
import irc.style.LimitedArray;
import irc.style.MultipleWordCatcher;
import irc.style.ResultPair;
import irc.style.StyledListListener;
import irc.style.StyledRectangle;
import irc.style.URLRecognizer;
import irc.style.WordListRecognizer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class StyledList
extends Panel
implements MouseListener,
MouseMotionListener,
FormattedStringDrawerListener {
    private LimitedArray _list;
    private Hashtable _nickInfos;
    private boolean _wrap;
    private int _last;
    private int _first;
    private int _left;
    private int _width;
    private int _toScrollX;
    private int _toScrollY;
    private FormattedStringDrawer _drawer;
    private Image _buffer;
    private int _bufferWidth;
    private int _bufferHeight;
    private int _lastWidth;
    private int _lastHeight;
    private Font _fonts;
    private Hashtable _results;
    private MultipleWordCatcher _catcher;
    private WordListRecognizer _wordListRecognizer;
    private IRCConfiguration _ircConfiguration;
    private int _pressedX;
    private int _pressedY;
    private int _draggedX;
    private int _draggedY;
    private boolean _dragging;
    private DrawResultItem _currentItem;
    private DrawResultItem _currentFloatItem;
    private String _currentFloatText;
    private String _copiedString;
    private boolean _fullDraw;
    private ListenerGroup _listeners;
    private ResultPair[] _addedResults;
    private int _addedCount;
    private int _hdirection;
    private int _vdirection;
    private Color _colormale;
    private Color _colorfemeale;
    private Color _colorundef;
    private Vector _updateItems;
    private long _lastRefresh = System.currentTimeMillis();
    private Image _backImage = null;
    private int _backTiling = 0;
    private int _maximumSize;
    private DecodedLine _emptyLine;
    private static final int BOTTOM = 0;
    private static final int TOP = 1;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    private static final boolean _doubleBuffer = true;

    public StyledList(IRCConfiguration iRCConfiguration, StyleContext styleContext) {
        this(iRCConfiguration, true, styleContext);
    }

    public StyledList(IRCConfiguration iRCConfiguration, boolean bl, StyleContext styleContext) {
        this(iRCConfiguration, bl, styleContext, Color.blue, Color.pink, Color.gray);
    }

    public StyledList(IRCConfiguration iRCConfiguration, boolean bl, StyleContext styleContext, Color color, Color color2, Color color3) {
        this._colormale = color;
        this._colorfemeale = color2;
        this._colorundef = color3;
        this._nickInfos = new Hashtable();
        this._fullDraw = false;
        this._addedResults = new ResultPair[64];
        for (int i = 0; i < this._addedResults.length; ++i) {
            this._addedResults[i] = new ResultPair();
        }
        this._addedCount = 0;
        this._hdirection = 0;
        this._vdirection = 0;
        this._ircConfiguration = iRCConfiguration;
        this._copiedString = "";
        this._dragging = false;
        this._currentFloatItem = null;
        this._currentFloatText = null;
        this._currentItem = null;
        this._toScrollX = 0;
        this._toScrollY = 0;
        this._left = 0;
        this._fonts = this._ircConfiguration.getStyleFont(styleContext);
        this._wrap = bl;
        this._buffer = null;
        this._drawer = new FormattedStringDrawer(this._ircConfiguration, styleContext, this);
        this._drawer.setHorizontalDirection(this._hdirection);
        this._drawer.setVerticalDirection(this._vdirection);
        this._catcher = new MultipleWordCatcher();
        this._wordListRecognizer = new WordListRecognizer();
        this._catcher.addRecognizer(new ChannelRecognizer());
        this._catcher.addRecognizer(new URLRecognizer());
        this._catcher.addRecognizer(this._wordListRecognizer);
        this._results = new Hashtable();
        this._listeners = new ListenerGroup();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this._maximumSize = this._ircConfiguration.getI("style:maximumlinecount");
        this._emptyLine = this._drawer.decodeLine("");
        this.clear();
        this.setBackgroundImage(this._ircConfiguration.getStyleBackgroundImage(styleContext));
        this.setBackgroundTiling(this._ircConfiguration.getStyleBackgroundTiling(styleContext));
        if (this._ircConfiguration.getB("style:righttoleft")) {
            this.setHorizontalDirection(1);
        }
    }

    public void release() {
        this.clear();
        this.dispose();
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    private void drawBackImage(Graphics graphics, int n, int n2) {
        int n3 = this._backImage.getWidth(this);
        int n4 = this._backImage.getHeight(this);
        switch (this._backTiling & 0xFF) {
            case 3: {
                int n5 = 0;
                int n6 = 0;
                if ((this._backTiling & 0x100) != 0) {
                    n5 = n - n3 - 1;
                }
                if ((this._backTiling & 0x200) != 0) {
                    n6 = n2 - n4 - 1;
                }
                graphics.setColor(this._drawer.getColor(0));
                graphics.fillRect(0, 0, n, n2);
                graphics.drawImage(this._backImage, n5, n6, this._drawer.getColor(0), this);
                break;
            }
            case 0: {
                int n7 = (n - n3) / 2;
                int n8 = (n2 - n4) / 2;
                graphics.setColor(this._drawer.getColor(0));
                graphics.fillRect(0, 0, n, n2);
                graphics.drawImage(this._backImage, n7, n8, this._drawer.getColor(0), this);
                break;
            }
            case 1: {
                graphics.drawImage(this._backImage, 0, 0, n, n2, this._drawer.getColor(0), this);
                break;
            }
            case 2: {
                for (int i = 0; i < n; i += n3) {
                    for (int j = 0; j < n2; j += n4) {
                        graphics.drawImage(this._backImage, i, j, this._drawer.getColor(0), this);
                    }
                }
                break;
            }
        }
    }

    private void expandResult() {
        ResultPair[] resultPairArray = new ResultPair[this._addedResults.length * 2];
        System.arraycopy(this._addedResults, 0, resultPairArray, 0, this._addedResults.length);
        for (int i = this._addedResults.length; i < resultPairArray.length; ++i) {
            resultPairArray[i] = new ResultPair();
        }
        this._addedResults = resultPairArray;
    }

    public void setHorizontalDirection(int n) {
        this._hdirection = n;
        this._drawer.setHorizontalDirection(this._hdirection);
    }

    public int getHorizontalDirection() {
        return this._hdirection;
    }

    public void setBackgroundImage(Image image) {
        this._backImage = image;
        this.repaint();
    }

    public void setBackgroundTiling(int n) {
        this._backTiling = n;
        this.repaint();
    }

    public void setFont(Font font) {
        this._fonts = font;
        this._drawer.setFont(font);
        this.reinit();
        this.repaint();
    }

    public void setWrap(boolean bl) {
        this._wrap = bl;
        this.reinit();
        this.repaint();
    }

    public synchronized void setNickList(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        this._nickInfos.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = "";
            int n = string.indexOf(":");
            if (n != -1) {
                string2 = string.substring(n + 1);
                string = string.substring(0, n);
            }
            stringArray2[i] = string;
            this._nickInfos.put(string.toLowerCase(Locale.ENGLISH), string2);
        }
        this._wordListRecognizer.setList(stringArray2);
    }

    public synchronized void addStyledListListener(StyledListListener styledListListener) {
        this._listeners.addListener(styledListListener);
    }

    public synchronized void removeStyledListListener(StyledListListener styledListListener) {
        this._listeners.removeListener(styledListListener);
    }

    public synchronized void setLeft(int n) {
        int n2 = this._left;
        this._left = n;
        if (this._left < 0) {
            this._left = 0;
        }
        if (this._left >= this.getLogicalWidth()) {
            this._left = this.getLogicalWidth() - 1;
        }
        if (this._hdirection == 1) {
            this._left = -this._left;
        }
        if (this._left != n2) {
            this.addToScroll(this._left - n2, 0);
            this.repaint();
        }
    }

    public int getLeft() {
        if (this._hdirection == 1) {
            return -this._left;
        }
        return this._left;
    }

    public synchronized void setFirst(int n) {
        if (this._vdirection != 1) {
            this._fullDraw = true;
        }
        this._vdirection = 1;
        this._drawer.setVerticalDirection(1);
        int n2 = this._first;
        this._first = n;
        if (this._first < 0) {
            this._last = 0;
        }
        if (this._first >= this._list.size()) {
            this._last = this._list.size() - 1;
        }
        if (this._first != n2) {
            this.addToScroll(0, this._first - n2);
            this.repaint();
        }
    }

    public synchronized void setLast(int n) {
        if (this._vdirection != 0) {
            this._fullDraw = true;
        }
        this._vdirection = 0;
        this._drawer.setVerticalDirection(0);
        int n2 = this._last;
        this._last = n;
        if (this._last < 0) {
            this._last = 0;
        }
        if (this._last >= this._list.size()) {
            this._last = this._list.size() - 1;
        }
        if (this._last != n2) {
            this.addToScroll(0, this._last - n2);
            this.repaint();
        }
    }

    public int getLogicalWidth() {
        return this._width;
    }

    public int getLast() {
        return this._last;
    }

    public synchronized int getLineCount() {
        return this._list.size();
    }

    public synchronized void addLine(String string) {
        DecodedLine decodedLine = this._drawer.decodeLine(string);
        this._list.add(decodedLine);
        if (this._vdirection == 0) {
            if (this._last == this._list.size() - 2) {
                this.setLast(this._last + 1);
            }
        } else if (this._vdirection == 1) {
            this._fullDraw = true;
            this.repaint();
        }
    }

    public synchronized void addLines(String[] stringArray) {
        boolean bl = this._list.size() - 1 == this._last;
        for (int i = 0; i < stringArray.length; ++i) {
            this._list.add(this._drawer.decodeLine(stringArray[i]));
        }
        if (this._vdirection == 0) {
            if (bl) {
                this.setLast(this._list.size() - 1);
            }
        } else if (this._vdirection == 1) {
            this._fullDraw = true;
            this.repaint();
        }
    }

    private void reinit() {
        if (this._buffer != null) {
            this._buffer.flush();
        }
        this._buffer = null;
        this._results = new Hashtable();
    }

    public synchronized void dispose() {
        this.reinit();
    }

    public synchronized void clear() {
        this._list = new LimitedArray(this._maximumSize);
        this._last = this._list.size() - 1;
        this._first = 0;
        this.setLeft(0);
        this._width = this.getSize().width;
        this._fullDraw = true;
        this.repaint();
    }

    private void drawPart(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        if (n2 < 0) {
            n4 += n2;
            n2 = 0;
        }
        if (this._backImage != null) {
            this.drawBackImage(graphics, n5, n6);
        } else {
            graphics.setColor(this._drawer.getColor(0));
            graphics.fillRect(n, n2, n3, n4);
        }
        if (this._vdirection == 0) {
            int n7;
            int n8 = this._last;
            for (n7 = this.getSize().height; n7 > n2 + n4 && n8 >= 0; n7 -= this.getHeight(n8--, graphics)) {
            }
            if (n8 != this._last) {
                n7 += this.getHeight(++n8, graphics);
            }
            this.draw(graphics, 0, n8, n7, n2, n, n + n3 - 1, bl);
        } else if (this._vdirection == 1) {
            int n9;
            int n10 = this._first;
            for (n9 = 0; n9 < n2 && n10 < this._list.size(); n9 += this.getHeight(n10++, graphics)) {
            }
            if (n10 != this._first) {
                n9 -= this.getHeight(--n10, graphics);
            }
            this.draw(graphics, n10, this._list.size() - 1, n9, n2 + n4, n, n + n3 - 1, bl);
        }
    }

    public synchronized void paint(Graphics graphics) {
        if (this._toScrollX != 0 || this._toScrollY != 0) {
            this._fullDraw = true;
        }
        this.update(graphics);
    }

    private int getHeight(Graphics graphics, int n, int n2) {
        int n3;
        if (n2 < n) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        n3 = 0;
        for (int i = n; i <= n2; ++i) {
            n3 += this.getHeight(i, graphics);
        }
        return n3;
    }

    private void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = this.getSize().width;
        this._addedCount = 0;
        DrawResult drawResult = new DrawResult();
        if (this._vdirection == 0) {
            StyledRectangle styledRectangle;
            for (int i = n2; i >= n && n3 > n4; n3 -= styledRectangle.height, --i) {
                DecodedLine decodedLine = (DecodedLine)this._list.get(i);
                if (decodedLine == null) {
                    decodedLine = this._emptyLine;
                }
                this._drawer.draw(decodedLine, graphics, -this._left, n7 - 1 - this._left, n3, n5, n6, bl, this._wrap, drawResult);
                styledRectangle = drawResult.rectangle;
                if (styledRectangle.width > this._width) {
                    this._width = styledRectangle.width;
                    this._listeners.sendEventAsync("virtualSizeChanged", this);
                }
                if (!bl) continue;
                ResultPair resultPair = this._addedResults[this._addedCount++];
                if (this._addedCount == this._addedResults.length) {
                    this.expandResult();
                }
                resultPair.line = i;
                resultPair.result = drawResult;
                drawResult = new DrawResult();
            }
        } else {
            StyledRectangle styledRectangle;
            for (int i = n; i <= n2 && n3 < n4; n3 += styledRectangle.height, ++i) {
                DecodedLine decodedLine = (DecodedLine)this._list.get(i);
                if (decodedLine == null) {
                    decodedLine = this._emptyLine;
                }
                this._drawer.draw(decodedLine, graphics, -this._left, n7 - 1 - this._left, n3, n5, n6, bl, this._wrap, drawResult);
                styledRectangle = drawResult.rectangle;
                if (styledRectangle.width > this._width) {
                    this._width = styledRectangle.width;
                    this._listeners.sendEventAsync("virtualSizeChanged", this);
                }
                if (!bl) continue;
                ResultPair resultPair = this._addedResults[this._addedCount++];
                if (this._addedCount == this._addedResults.length) {
                    this.expandResult();
                }
                resultPair.line = i;
                resultPair.result = drawResult;
                drawResult = new DrawResult();
            }
        }
    }

    private void addToScroll(int n, int n2) {
        this._toScrollX += n;
        this._toScrollY += n2;
    }

    private int getScrollX() {
        if (this._dragging) {
            return 0;
        }
        int n = this._toScrollX;
        this._toScrollX = 0;
        return n;
    }

    private int getScrollY() {
        if (this._dragging) {
            return 0;
        }
        int n = this._toScrollY;
        this._toScrollY = 0;
        return n;
    }

    private void scrollDrawItems(int n, int n2) {
        int n3 = this.getSize().height;
        Enumeration enumeration = this._results.keys();
        while (enumeration.hasMoreElements()) {
            Integer n4 = (Integer)enumeration.nextElement();
            DrawResult drawResult = (DrawResult)this._results.get(n4);
            drawResult.rectangle.x += n;
            drawResult.rectangle.y += n2;
            if (drawResult.rectangle.y + drawResult.rectangle.height >= 0 && drawResult.rectangle.y < n3) continue;
            this._results.remove(n4);
        }
    }

    private void combineItems() {
        for (int i = 0; i < this._addedCount; ++i) {
            ResultPair resultPair = this._addedResults[i];
            this._results.put(new Integer(resultPair.line), resultPair.result);
        }
        this._addedCount = 0;
    }

    private DrawResultItem findItem(int n, int n2) {
        Enumeration enumeration = this._results.elements();
        while (enumeration.hasMoreElements()) {
            DrawResult drawResult = (DrawResult)enumeration.nextElement();
            if (!drawResult.rectangle.contains(n, n2)) continue;
            int n3 = n - drawResult.rectangle.x;
            int n4 = n2 - drawResult.rectangle.y;
            for (int i = 0; i < drawResult.items.length; ++i) {
                DrawResultItem drawResultItem = drawResult.items[i];
                if (!drawResultItem.rectangle.contains(n3, n4)) continue;
                return drawResultItem;
            }
        }
        return null;
    }

    private int findLine(int n) {
        Enumeration enumeration = this._results.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            DrawResult drawResult = (DrawResult)this._results.get(n2);
            if (drawResult.rectangle.y > n || drawResult.rectangle.y + drawResult.rectangle.height <= n) continue;
            return n2;
        }
        return -1;
    }

    private int getHeight(int n, Graphics graphics) {
        DrawResult drawResult = (DrawResult)this._results.get(new Integer(n));
        if (drawResult != null) {
            return drawResult.rectangle.height;
        }
        int n2 = this.getSize().width;
        DecodedLine decodedLine = (DecodedLine)this._list.get(n);
        if (decodedLine == null) {
            decodedLine = this._emptyLine;
        }
        return this._drawer.getHeight(decodedLine, graphics, -this._left, n2, this._wrap);
    }

    private Color findColor(String string) {
        return this._ircConfiguration.getASLColor(string, this._colormale, this._colorfemeale, this._colorundef);
    }

    private synchronized Vector getUpdateItems() {
        Vector vector = this._updateItems;
        this._updateItems = null;
        return vector;
    }

    private synchronized boolean addToUpdateItems(Integer n) {
        if (this._updateItems == null) {
            this._updateItems = new Vector();
        }
        for (int i = 0; i < this._updateItems.size(); ++i) {
            Integer n2 = (Integer)this._updateItems.elementAt(i);
            if (!n2.equals(n)) continue;
            return false;
        }
        this._updateItems.insertElementAt(n, this._updateItems.size());
        return true;
    }

    public synchronized void update(Graphics graphics) {
        Object object;
        Object object2;
        int n;
        int n2 = this.getSize().width;
        int n3 = this.getSize().height;
        if (n3 <= 0 || n2 <= 0) {
            return;
        }
        Graphics graphics2 = graphics;
        if (this._buffer != null) {
            if (this._bufferWidth < n2 || this._bufferHeight < n3) {
                this.reinit();
            }
            if (this._lastWidth != n2 || this._lastHeight != n3) {
                this._fullDraw = true;
            }
        }
        this._lastWidth = n2;
        this._lastHeight = n3;
        if (this._buffer == null) {
            this._buffer = this.createImage(n2, n3);
            if (this._buffer == null) {
                this.repaint();
                return;
            }
            this._bufferWidth = n2;
            this._bufferHeight = n3;
            this._fullDraw = true;
        }
        graphics2 = this._buffer.getGraphics();
        if (this._ircConfiguration.getB("style:backgroundimage")) {
            this._fullDraw = true;
        }
        int n4 = this.getScrollX();
        int n5 = this.getScrollY();
        Vector vector = this.getUpdateItems();
        if (!this._fullDraw) {
            if (n4 < 0) {
                graphics2.copyArea(0, 0, n2 + n4, n3, -n4, 0);
                this.scrollDrawItems(-n4, 0);
                this.drawPart(graphics2, 0, 0, -n4, n3, false, n2, n3);
            } else if (n4 > 0) {
                graphics2.copyArea(n4, 0, n2 - n4, n3, -n4, 0);
                this.scrollDrawItems(-n4, 0);
                this.drawPart(graphics2, n2 - n4, 0, n4, n3, false, n2, n3);
            }
            if (n5 > 0) {
                n = this._vdirection == 0 ? this.getHeight(graphics2, this._last - n5 + 1, this._last) : this.getHeight(graphics2, this._first - n5, this._first - 1);
                graphics2.copyArea(0, n, n2, n3 - n, 0, -n);
                this.scrollDrawItems(0, -n);
                this.drawPart(graphics2, 0, n3 - n, n2, n, true, n2, n3);
                this.combineItems();
            } else if (n5 < 0) {
                n = this._vdirection == 0 ? this.getHeight(graphics2, this._last + 1, this._last - n5) : this.getHeight(graphics2, this._first, this._first - n5 - 1);
                graphics2.copyArea(0, 0, n2, n3 - n, 0, n);
                this.scrollDrawItems(0, n);
                this.drawPart(graphics2, 0, 0, n2, n, true, n2, n3);
                this.combineItems();
            }
            if (vector != null) {
                for (n = 0; n < vector.size(); ++n) {
                    Integer n6 = (Integer)vector.elementAt(n);
                    object2 = (DrawResult)this._results.get(n6);
                    if (object2 == null) continue;
                    object = ((DrawResult)object2).rectangle;
                    this.drawPart(graphics2, ((StyledRectangle)object).x, ((StyledRectangle)object).y, ((StyledRectangle)object).width, ((StyledRectangle)object).height, false, n2, n3);
                }
            }
        } else {
            this._results = new Hashtable();
            this.drawPart(graphics2, 0, 0, n2, n3, true, n2, n3);
            this.combineItems();
            this._fullDraw = false;
        }
        if (this._dragging) {
            this.makeXor(graphics2);
        }
        graphics.drawImage(this._buffer, 0, 0, this);
        if (this._dragging) {
            this.makeXor(graphics2);
        }
        if (!this._dragging && this._currentFloatItem != null && this._ircConfiguration.getB("style:floatingasl")) {
            n = this._currentFloatItem.rectangle.x + this._currentFloatItem.parent.rectangle.x + 4;
            int n7 = this._currentFloatItem.rectangle.y + this._currentFloatItem.parent.rectangle.y;
            n7 = this._vdirection == 1 ? (n7 += 8) : (n7 -= 8);
            if (n7 < 0) {
                n7 = 0;
            }
            if (((String)(object = this._ircConfiguration.formatASL((String)(object2 = this._currentFloatText)))).length() > 0) {
                int n8 = graphics.getFontMetrics().stringWidth((String)object);
                int n9 = graphics.getFont().getSize();
                if (n7 + n9 + 5 > n3) {
                    n7 = n3 - n9 - 5;
                }
                if (n + n8 + 5 > n2) {
                    n = n2 - n8 - 5;
                }
                graphics.setColor(this.getAlphaColor(this.findColor((String)object2), this._ircConfiguration.getI("style:floatingaslalpha")));
                graphics.fillRect(n, n7, n8 + 4, n9 + 4);
                graphics.setColor(Color.white);
                graphics.drawString((String)object, n + 2, n7 + n9);
            }
        }
    }

    private Color getAlphaColor(Color color, int n) {
        try {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
        }
        catch (Throwable throwable) {
            return color;
        }
    }

    private void makeXor(Graphics graphics) {
        int n;
        int n2;
        String string = "";
        int n3 = this._draggedX - this._pressedX;
        int n4 = this._draggedY - this._pressedY;
        int n5 = this._pressedX;
        int n6 = this._pressedY;
        graphics.setXORMode(Color.white);
        graphics.setColor(Color.black);
        int n7 = n2 = this.findLine(n6);
        DrawResult drawResult = (DrawResult)this._results.get(new Integer(n2));
        if (drawResult == null) {
            this._copiedString = "";
            return;
        }
        int n8 = n5 - drawResult.rectangle.x;
        int n9 = n6 - drawResult.rectangle.y;
        DrawResultItem drawResultItem = null;
        int n10 = 0;
        for (n = 0; n < drawResult.items.length; ++n) {
            if (!drawResult.items[n].rectangle.contains(n8, n9)) continue;
            drawResultItem = drawResult.items[n];
            n10 = n;
        }
        if (drawResultItem == null || n8 + n3 < drawResultItem.rectangle.x && n9 + n4 < drawResultItem.rectangle.y || n9 + n4 < drawResultItem.rectangle.y) {
            this._copiedString = "";
            return;
        }
        boolean bl = false;
        while (!bl) {
            string = string + drawResultItem.originalstrippedword;
            StyledRectangle styledRectangle = drawResultItem.rectangle;
            graphics.fillRect(styledRectangle.x + drawResult.rectangle.x, styledRectangle.y + drawResult.rectangle.y, styledRectangle.width, styledRectangle.height);
            if ((n2 != n7 || n != n10) && drawResultItem.rectangle.contains(n8 + n3, n9 + n4)) break;
            if (++n10 >= drawResult.items.length) {
                n10 = 0;
                if ((drawResult = (DrawResult)this._results.get(new Integer(++n2))) == null) break;
                n8 = n5 - drawResult.rectangle.x;
                n9 = n6 - drawResult.rectangle.y;
                string = string + "\n";
            }
            drawResultItem = drawResult.items[n10];
            if (drawResultItem.rectangle.y > n9 + n4) {
                bl = true;
            }
            if (this._hdirection == 0 && drawResultItem.rectangle.x > n8 + n3 && drawResultItem.rectangle.y + drawResultItem.rectangle.height > n9 + n4) {
                bl = true;
            }
            if (this._hdirection != 1 || drawResultItem.rectangle.x + drawResultItem.rectangle.width >= n8 + n3 || drawResultItem.rectangle.y + drawResultItem.rectangle.height <= n9 + n4) continue;
            bl = true;
        }
        this._copiedString = string;
        graphics.setPaintMode();
    }

    public synchronized void mouseClicked(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 1) != 0) {
            String string = "";
            for (int i = 0; i < this._list.size(); ++i) {
                DecodedLine decodedLine = (DecodedLine)this._list.get(i);
                if (decodedLine == null) {
                    decodedLine = this._emptyLine;
                }
                string = string + decodedLine.original + "\n";
            }
            this._listeners.sendEventAsync("copyEvent", this, string, mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this._currentFloatItem = null;
        this._currentItem = null;
        this.repaint();
    }

    public synchronized void mousePressed(MouseEvent mouseEvent) {
        String string;
        this._pressedX = mouseEvent.getX();
        this._pressedY = mouseEvent.getY();
        this._draggedX = this._pressedX;
        this._draggedY = this._pressedY;
        this._copiedString = "";
        this._dragging = false;
        this._currentItem = null;
        DrawResultItem drawResultItem = this.findItem(mouseEvent.getX(), mouseEvent.getY());
        if (drawResultItem != null && (string = this._catcher.getType(drawResultItem.item)) != null) {
            if (string.equals("channel")) {
                this._listeners.sendEventAsync("channelEvent", this, drawResultItem.item, mouseEvent);
            } else if (string.equals("url")) {
                this._listeners.sendEventAsync("URLEvent", this, drawResultItem.item, mouseEvent);
            } else if (string.equals("wordlist")) {
                this._listeners.sendEventAsync("nickEvent", this, drawResultItem.item, mouseEvent);
            }
        }
    }

    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        if (this._dragging) {
            this._dragging = false;
            this.repaint();
            if (this._copiedString.length() > 0) {
                this._listeners.sendEventAsync("copyEvent", this, this._copiedString, mouseEvent);
            }
        }
    }

    public synchronized void mouseDragged(MouseEvent mouseEvent) {
        this._draggedX = mouseEvent.getX();
        this._draggedY = mouseEvent.getY();
        this._dragging = true;
        DrawResultItem drawResultItem = this.findItem(mouseEvent.getX(), mouseEvent.getY());
        if (drawResultItem != this._currentItem) {
            this._currentItem = drawResultItem;
            this.repaint();
        }
    }

    private void handCursor() {
        if (!this.getCursor().equals(new Cursor(12))) {
            this.setCursor(new Cursor(12));
        }
    }

    private void defCursor() {
        if (!this.getCursor().equals(new Cursor(0))) {
            this.setCursor(new Cursor(0));
        }
    }

    private boolean sameItem(DrawResultItem drawResultItem, DrawResultItem drawResultItem2) {
        if (drawResultItem == null && drawResultItem2 == null) {
            return true;
        }
        if (drawResultItem == null) {
            return false;
        }
        if (drawResultItem2 == null) {
            return false;
        }
        return drawResultItem.equals(drawResultItem2);
    }

    public synchronized void mouseMoved(MouseEvent mouseEvent) {
        DrawResultItem drawResultItem = this.findItem(mouseEvent.getX(), mouseEvent.getY());
        DrawResultItem drawResultItem2 = this._currentFloatItem;
        if (!this.sameItem(drawResultItem, this._currentItem)) {
            this._currentItem = drawResultItem;
            this._currentFloatItem = null;
            if (drawResultItem != null) {
                String string = this._catcher.getType(drawResultItem.item);
                if (string != null) {
                    this.handCursor();
                    if (string.equals("wordlist")) {
                        String string2 = (String)this._nickInfos.get(drawResultItem.item.toLowerCase(Locale.ENGLISH));
                        if (string2 == null) {
                            string2 = "";
                        }
                        if (string2.length() == 0) {
                            this._currentFloatItem = null;
                        } else {
                            this._currentFloatItem = drawResultItem;
                            this._currentFloatText = string2;
                        }
                    }
                } else {
                    this.defCursor();
                }
            } else {
                this.defCursor();
            }
        }
        if (!this.sameItem(drawResultItem2, this._currentFloatItem) && this._ircConfiguration.getB("style:floatingasl")) {
            this.repaint();
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        this._fullDraw = true;
        this.repaint();
        return true;
    }

    public synchronized Boolean displayUpdated(Object object, Integer n) {
        boolean bl = false;
        Enumeration enumeration = this._results.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            DrawResult drawResult = (DrawResult)this._results.get(n2);
            if (drawResult.updateHandles == null) continue;
            for (int i = 0; i < drawResult.updateHandles.size(); ++i) {
                if (!drawResult.updateHandles.elementAt(i).equals(object)) continue;
                if ((n & 2) != 0) {
                    this._fullDraw = true;
                    this.repaint();
                    return Boolean.TRUE;
                }
                bl = true;
                this.addToUpdateItems(n2);
                if (System.currentTimeMillis() - this._lastRefresh <= 10L && (n & 1) == 0) continue;
                this.repaint();
                this._lastRefresh = System.currentTimeMillis();
            }
        }
        if (bl) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

