/*
 * Decompiled with CFR 0.152.
 */
package irc.security;

import irc.EventDispatcher;
import irc.security.DefaultSecuredProvider;
import irc.security.SecuredProvider;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class SecurityProvider
implements ActionListener {
    private SecuredProvider _provider;
    private Object _lock = new Object();
    private boolean _answer;

    public SecurityProvider() {
        if (this.tryProvider("MS")) {
            return;
        }
        this._provider = new DefaultSecuredProvider();
    }

    private boolean tryProvider(String string) {
        SecuredProvider securedProvider = this._provider;
        try {
            Class<?> clazz = Class.forName("irc.security.prv.Specific" + string + "SecuredProvider");
            this._provider = (SecuredProvider)clazz.newInstance();
            if (!this._provider.tryProvider()) {
                throw new Exception();
            }
            return true;
        }
        catch (Exception exception) {
            this._provider = securedProvider;
            return false;
        }
    }

    public String getProviderName() {
        return this._provider.getName();
    }

    public Socket getSocket(String string, int n) throws UnknownHostException, IOException {
        try {
            Socket socket = (Socket)EventDispatcher.dispatchEventAsyncAndWaitEx(this._provider, "getSocket", new Object[]{string, new Integer(n)});
            return socket;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getClass().getName() + " : " + throwable.getMessage());
        }
    }

    public ServerSocket getServerSocket(int n) throws IOException {
        try {
            return (ServerSocket)EventDispatcher.dispatchEventAsyncAndWaitEx(this._provider, "getServerSocket", new Object[]{new Integer(n)});
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getClass().getName() + " : " + throwable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean confirm(String string) {
        Frame frame = new Frame();
        frame.setTitle("Security warning");
        frame.setLayout(new BorderLayout());
        frame.add((Component)new Label(string), "Center");
        Button button = new Button("Yes");
        Button button2 = new Button("No");
        Panel panel = new Panel();
        frame.add((Component)panel, "South");
        frame.setResizable(false);
        panel.add(button);
        panel.add(button2);
        button.addActionListener(this);
        button2.addActionListener(this);
        frame.pack();
        frame.show();
        this._answer = false;
        Object object = this._lock;
        synchronized (object) {
            try {
                this._lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        button.removeActionListener(this);
        button2.removeActionListener(this);
        frame.hide();
        frame.dispose();
        frame = null;
        return this._answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Button button = (Button)actionEvent.getSource();
        this._answer = false;
        if (button.getLabel().equals("Yes")) {
            this._answer = true;
        }
        Object object = this._lock;
        synchronized (object) {
            this._lock.notifyAll();
        }
    }

    public FileInputStream getFileInputStream(File file) throws IOException {
        if (!this.confirm("Authorize file read action on " + file + "?")) {
            throw new IOException("User denied access");
        }
        try {
            return (FileInputStream)EventDispatcher.dispatchEventAsyncAndWaitEx(this._provider, "getFileInputStream", new Object[]{file});
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getMessage());
        }
    }

    public FileOutputStream getFileOutputStream(File file) throws IOException {
        if (!this.confirm("Authorize file write action on " + file + "?")) {
            throw new IOException("User denied access");
        }
        try {
            return (FileOutputStream)EventDispatcher.dispatchEventAsyncAndWaitEx(this._provider, "getFileOutputStream", new Object[]{file});
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getMessage());
        }
    }

    public int getFileSize(File file) {
        try {
            return (Integer)EventDispatcher.dispatchEventAsyncAndWaitEx(this._provider, "getFileSize", new Object[]{file});
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public File getLoadFile(String string) {
        try {
            return (File)EventDispatcher.dispatchEventAsyncAndWaitEx(this._provider, "getLoadFile", new Object[]{string});
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public File getSaveFile(String string) {
        try {
            return (File)EventDispatcher.dispatchEventAsyncAndWaitEx(this._provider, "getSaveFile", new Object[]{string});
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public File getSaveFile(String string, String string2) {
        try {
            return (File)EventDispatcher.dispatchEventAsyncAndWaitEx(this._provider, "getSaveFile", new Object[]{string, string2});
        }
        catch (Throwable throwable) {
            return this.getSaveFile(string2);
        }
    }

    public InetAddress getLocalHost() throws UnknownHostException {
        try {
            return (InetAddress)EventDispatcher.dispatchEventAsyncAndWaitEx(this._provider, "getLocalHost", new Object[0]);
        }
        catch (InterruptedException interruptedException) {
            throw new UnknownHostException("Unable to resolve");
        }
        catch (Throwable throwable) {
            throw new UnknownHostException(throwable.getMessage());
        }
    }

    public String resolve(InetAddress inetAddress) {
        try {
            return (String)EventDispatcher.dispatchEventAsyncAndWaitEx(this._provider, "resolve", new Object[]{inetAddress});
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

