/*
 * Decompiled with CFR 0.152.
 */
package irc.dcc.prv;

import irc.CodingHandler;
import irc.EventDispatcher;
import irc.IRCConfiguration;
import irc.IRCObject;
import irc.ListenerGroup;
import irc.Server;
import irc.ServerListener;
import irc.Source;
import irc.dcc.DCCChat;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class DCCChatServer
extends IRCObject
implements Runnable,
Server {
    private Socket _socket;
    private ServerSocket _serverSocket;
    private CodingHandler _handler;
    private Thread _thread;
    private DCCChat _chat;
    private String _remoteNick;
    private String _thisNick;
    private ListenerGroup _listeners = new ListenerGroup();
    private boolean _listening;
    private int _action = 0;
    private boolean _connected;

    public DCCChatServer(IRCConfiguration iRCConfiguration, String string, String string2) {
        super(iRCConfiguration);
        this._remoteNick = string2;
        this._thisNick = string;
        this._connected = false;
        this._chat = new DCCChat(this._ircConfiguration, this, this._remoteNick);
    }

    public void addServerListener(ServerListener serverListener) {
        this._listeners.addListener(serverListener);
    }

    public void removeServerListener(ServerListener serverListener) {
        this._listeners.removeListener(serverListener);
    }

    public void connect() {
    }

    public void disconnect() {
        this.close();
    }

    public boolean isConnected() {
        return this._connected;
    }

    public Enumeration getSources() {
        Vector<DCCChat> vector = new Vector<DCCChat>();
        if (this._chat != null) {
            vector.insertElementAt(this._chat, 0);
        }
        return vector.elements();
    }

    public void enumerateSourcesAsCreated(ServerListener serverListener) {
        if (this._chat != null) {
            serverListener.sourceCreated(this._chat, this, new Boolean(this._action == 2));
        }
    }

    public void enumerateSourcesAsRemoved(ServerListener serverListener) {
        if (this._chat != null) {
            serverListener.sourceRemoved(this._chat, this);
        }
    }

    public void setDefaultSource(Source source) {
    }

    public void release() {
        this.cleanup();
        this._chat = null;
        super.release();
    }

    public void openActive(String string, String string2) {
        this._serverSocket = null;
        this._action = 1;
        long l = new Long(string);
        int n = (int)(l & 0xFFL);
        int n2 = (int)(l >> 8 & 0xFFL);
        int n3 = (int)(l >> 16 & 0xFFL);
        int n4 = (int)(l >> 24 & 0xFFL);
        string = n4 + "." + n3 + "." + n2 + "." + n;
        try {
            this._socket = this._ircConfiguration.getSecurityProvider().getSocket(string, new Integer(string2));
            this._handler = new CodingHandler(this._ircConfiguration, this._socket.getInputStream(), this._socket.getOutputStream());
            this._thread = new Thread((Runnable)this, "DCCChat thread");
            this._thread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String openPassive() {
        this._action = 2;
        this._socket = null;
        try {
            int n;
            int n2;
            int n3;
            this._serverSocket = this._ircConfiguration.getSecurityProvider().getServerSocket(0);
            int n4 = this._serverSocket.getLocalPort();
            InetAddress inetAddress = this._ircConfiguration.getSecurityProvider().getLocalHost();
            byte[] byArray = inetAddress.getAddress();
            int n5 = byArray[0];
            if (n5 < 0) {
                n5 += 256;
            }
            if ((n3 = byArray[1]) < 0) {
                n3 += 256;
            }
            if ((n2 = byArray[2]) < 0) {
                n2 += 256;
            }
            if ((n = byArray[3]) < 0) {
                n += 256;
            }
            long l = (n5 << 24) + (n3 << 16) + (n2 << 8) + n;
            String string = "" + l;
            this._listening = false;
            this._thread = new Thread((Runnable)this, "DCCChat thread");
            this._thread.start();
            while (!this._listening) {
                Thread.yield();
            }
            return string + " " + n4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    private void reportChat(String string) {
        EventDispatcher.dispatchEventAsync(this._chat, "report", new Object[]{string});
    }

    private void messageChat(String string, String string2) {
        EventDispatcher.dispatchEventAsync(this._chat, "messageReceived", new Object[]{string, string2});
    }

    public void run() {
        boolean bl = false;
        if (this._action == 2) {
            try {
                this._listening = true;
                this.reportChat(this.getText(257));
                this._serverSocket.setSoTimeout(30000);
                this._socket = this._serverSocket.accept();
                this._handler = new CodingHandler(this._ircConfiguration, this._socket.getInputStream(), this._socket.getOutputStream());
            }
            catch (Exception exception) {
                this.reportChat(this.getText(258, exception.getMessage()));
                return;
            }
        }
        this.reportChat(this.getText(259));
        this._connected = true;
        this._listeners.sendEventAsync("serverConnected", this);
        while (!bl) {
            try {
                String string = this._handler.read();
                if (string == null) {
                    throw new Exception(this.getText(260));
                }
                try {
                    this.messageChat(this._remoteNick, string);
                }
                catch (Exception exception) {
                    System.err.println("internal error");
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                bl = true;
                this.reportChat(this.getText(261, exception.getMessage()));
            }
        }
        this._connected = false;
        this._listeners.sendEventAsync("serverDisconnected", this);
        this.cleanup();
    }

    public void say(String string, String string2) {
        if (string.equals(this._remoteNick)) {
            this.sendString(string2);
        } else {
            this._chat.report(this.getText(261, this.getText(262, string)));
        }
    }

    public void execute(String string) {
        this._chat.report(this.getText(263));
    }

    private void sendString(String string) {
        try {
            if (this._handler == null || !this._connected) {
                throw new Exception(this.getText(264));
            }
            this._handler.write(string);
        }
        catch (Exception exception) {
            this._chat.report(this.getText(261, exception.getMessage()));
        }
    }

    public void sendStatusMessage(String string) {
        if (this._chat != null) {
            this._chat.report(string);
        }
    }

    private void cleanup() {
        try {
            if (this._socket != null) {
                this._socket.close();
            }
            if (this._serverSocket != null) {
                this._serverSocket.close();
            }
            this._handler.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        this.cleanup();
    }

    public void leave() {
        this.disconnect();
        long l = System.currentTimeMillis();
        while (this.isConnected()) {
            try {
                Thread.sleep(100L);
                if (System.currentTimeMillis() - l <= 10000L) continue;
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this._listeners.sendEvent("sourceRemoved", this._chat, this);
        this._listeners.sendEvent("serverLeft", this);
        this._chat.release();
    }

    public String getNick() {
        return this._thisNick;
    }

    public String getUserName() {
        return "";
    }
}

