/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.CodingHandler;
import irc.EventDispatcher;
import irc.IRCConfiguration;
import irc.IRCObject;
import irc.ListenerGroup;
import irc.ServerProtocolListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.net.Socket;
import java.util.Vector;

public class ServerProtocol
extends IRCObject
implements Runnable {
    private ListenerGroup _listeners = new ListenerGroup();
    private String _host;
    private int _port;
    private Socket _socket;
    private CodingHandler _handler;
    private Thread _thread;
    private boolean _connected = false;
    private boolean _connecting = false;

    public ServerProtocol(IRCConfiguration iRCConfiguration) {
        super(iRCConfiguration);
    }

    public void connect(String string, int n) {
        if (this._connected) {
            this.disconnect();
        }
        this._connecting = true;
        this._host = string;
        this._port = n;
        this._thread = new Thread((Runnable)this, "Read thread");
        this._thread.start();
    }

    public boolean connected() {
        return this._connected;
    }

    public boolean connecting() {
        return this._connecting;
    }

    public synchronized void disconnect() {
        if (!this._connected) {
            return;
        }
        if (this._connecting) {
            return;
        }
        try {
            this._socket.close();
            this._handler.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._connected = false;
        this._listeners.sendEvent("disconnected", this._host);
    }

    public int getLocalPort() {
        return this._socket.getLocalPort();
    }

    private void decodeLine(String string) {
        String string2;
        Vector<String> vector = new Vector<String>();
        while (string.length() != 0) {
            if (string.startsWith(":") && vector.size() != 0) {
                vector.insertElementAt(string.substring(1), vector.size());
                string = "";
                continue;
            }
            int n = string.indexOf(32);
            if (n == -1) {
                vector.insertElementAt(string, vector.size());
                string = "";
                continue;
            }
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
            vector.insertElementAt(string2, vector.size());
        }
        if (vector.size() == 0) {
            return;
        }
        String string3 = "";
        if (((String)vector.elementAt(0)).startsWith(":")) {
            string3 = (String)vector.elementAt(0);
            string3 = string3.substring(1);
            vector.removeElementAt(0);
        }
        if (vector.size() == 0) {
            return;
        }
        string2 = (String)vector.elementAt(0);
        vector.removeElementAt(0);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        if (string2.charAt(0) >= '0' && string2.charAt(0) <= '9') {
            this._listeners.sendEventAsync("replyReceived", string3, string2, stringArray);
        } else {
            this._listeners.sendEventAsync("messageReceived", string3, string2, stringArray);
        }
    }

    public void run() {
        try {
            this._socket = this._ircConfiguration.getSecurityProvider().getSocket(this._host, this._port);
            this._handler = new CodingHandler(this._ircConfiguration, new BufferedInputStream(this._socket.getInputStream()), new BufferedOutputStream(this._socket.getOutputStream()));
            this._connected = true;
            this._connecting = false;
            this._listeners.sendEventAsync("connected", this._host);
        }
        catch (Exception exception) {
            this._connecting = false;
            if (exception.getMessage() != null) {
                this._listeners.sendEventAsync("connectionFailed", exception.getMessage(), this._host);
            } else {
                this._listeners.sendEventAsync("connectionFailed", exception.getClass().getName(), this._host);
            }
            return;
        }
        boolean bl = false;
        while (!bl) {
            try {
                String string = this._handler.read();
                if (string == null) {
                    throw new Exception();
                }
                try {
                    if (string == null) continue;
                    this.decodeLine(string);
                }
                catch (Exception exception) {
                    System.err.println("internal error");
                    System.err.println("please submit a bug report to plouf@pjirc.com with the following information :");
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        EventDispatcher.dispatchEventAsync(this, "disconnect", new Object[0]);
    }

    public void addServerProtocolListener(ServerProtocolListener serverProtocolListener) {
        this._listeners.addListener(serverProtocolListener);
    }

    public void removeServerProtocolListener(ServerProtocolListener serverProtocolListener) {
        this._listeners.removeListener(serverProtocolListener);
    }

    public void sendString(String string) throws Exception {
        if (!this.connected()) {
            throw new Exception(this.getText(1285));
        }
        this._handler.write(string);
    }

    public void sendCommand(String string, String[] stringArray) throws Exception {
        String string2 = string;
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 + " ";
            if (stringArray[i].indexOf(32) != -1) {
                string2 = string2 + ":";
            }
            string2 = string2 + stringArray[i];
        }
        this.sendString(string2);
    }
}

