/*
 * Decompiled with CFR 0.152.
 */
package irc.tree;

import irc.tree.Comparator;
import irc.tree.TreeNode;
import irc.tree.TreeTraversalListener;
import java.util.Enumeration;
import java.util.Vector;

public class SortedList
implements TreeTraversalListener {
    private TreeNode _root;
    private Vector _items;
    private Comparator _comparator;
    private boolean _upToDate;

    public SortedList(Comparator comparator) {
        this._comparator = comparator;
        this._root = new TreeNode(this._comparator);
        this._items = new Vector();
        this._upToDate = false;
    }

    public int getSize() {
        if (!this._upToDate) {
            this.computeVector();
        }
        return this._items.size();
    }

    public void add(Object object) {
        try {
            this._root = this._root.add(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._upToDate = false;
    }

    public void remove(Object object) {
        try {
            this._root = this._root.remove(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._upToDate = false;
    }

    public void begin(Object object) {
        this._items = new Vector();
    }

    public void nextItem(Object object, Object object2) {
        this._items.insertElementAt(object, this._items.size());
    }

    public void end(Object object) {
        this._upToDate = true;
    }

    private void computeVector() {
        this.getItems(this, null);
    }

    public Enumeration getItems() {
        if (!this._upToDate) {
            this.computeVector();
        }
        return this._items.elements();
    }

    public Object getItemAt(int n) {
        if (!this._upToDate) {
            this.computeVector();
        }
        return this._items.elementAt(n);
    }

    public void getItems(TreeTraversalListener treeTraversalListener, Object object) {
        treeTraversalListener.begin(object);
        this._root.inorder(treeTraversalListener, object);
        treeTraversalListener.end(object);
    }
}

