/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.ChanList;
import irc.ChanListListener;
import irc.ChannelInfo;
import irc.Source;
import irc.gui.pixx.BaseAWTSource;
import irc.gui.pixx.ChanListNameComparator;
import irc.gui.pixx.PixxConfiguration;
import irc.gui.pixx.PixxHorizontalScrollBar;
import irc.gui.pixx.PixxScrollBar;
import irc.style.StyledList;
import irc.tree.SortedList;
import java.awt.Component;
import java.util.Enumeration;

public class AWTChanList
extends BaseAWTSource
implements ChanListListener {
    protected PixxHorizontalScrollBar _hscroll;
    private SortedList _sortedList = new SortedList(new ChanListNameComparator());

    public AWTChanList(PixxConfiguration pixxConfiguration, ChanList chanList) {
        super(pixxConfiguration, (Source)chanList, true);
        chanList.addChanListListener((ChanListListener)this);
        this._hscroll = new PixxHorizontalScrollBar(this._pixxConfiguration, 0, 0, 0.1);
        this._hscroll.addPixxScrollBarListener(this);
        this._list.setWrap(false);
        this.remove((Component)this._textField);
        this.add((Component)this._hscroll, "South");
        this.setTitle(this.getText(34307, this.getChanList().getName()));
    }

    public void release() {
        ((ChanList)this._source).removeChanListListeners((ChanListListener)this);
        this._hscroll.removePixxScrollBarListener(this);
        this._hscroll.release();
        this._hscroll = null;
        super.release();
    }

    public String getShortTitle() {
        return this.getText(34580);
    }

    public void setFieldText(String string) {
    }

    public String getFieldText() {
        return "";
    }

    public void validateText() {
    }

    public ChanList getChanList() {
        return (ChanList)this.getSource();
    }

    public void channelBegin(ChanList chanList) {
        this.clear(this.getSource());
        this.print(this._pixxConfiguration.getText(34308));
        this._list.setFirst(0);
        this._sortedList = new SortedList(new ChanListNameComparator());
    }

    public void channelEnd(ChanList chanList) {
        this.clear(this.getSource());
        String[] stringArray = new String[this._sortedList.getSize()];
        Enumeration enumeration = this._sortedList.getItems();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ChannelInfo channelInfo = (ChannelInfo)enumeration.nextElement();
            stringArray[n++] = this.format(channelInfo);
        }
        this._list.addLines(stringArray);
        this._list.setFirst(0);
        this._scroll.setMaximum(this._list.getLineCount() - 1);
        this._scroll.setValue(this._list.getLast());
        this._hscroll.setMaximum(this._list.getLogicalWidth() / 10);
    }

    private String format(ChannelInfo channelInfo) {
        int n;
        String string = channelInfo.name;
        String string2 = "" + channelInfo.userCount;
        for (n = 0; n < 20 - channelInfo.name.length(); ++n) {
            string = string + " ";
        }
        string = string + "   " + channelInfo.userCount;
        for (n = 0; n < 5 - string2.length(); ++n) {
            string = string + " ";
        }
        string = string + "   " + channelInfo.topic;
        return string;
    }

    public void channelAdded(ChannelInfo channelInfo, ChanList chanList) {
        this._sortedList.add(channelInfo);
    }

    public void valueChanged(PixxScrollBar pixxScrollBar) {
        if (pixxScrollBar == this._hscroll) {
            this._list.setLeft(this._hscroll.getValue() * 10);
        } else {
            super.valueChanged(pixxScrollBar);
        }
    }

    public void virtualSizeChanged(StyledList styledList) {
        this._hscroll.setMaximum(this._list.getLogicalWidth() / 10);
        super.virtualSizeChanged(styledList);
    }
}

